/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.tickable;

import java.util.Map;
import net.arna.jcraft.api.registry.JTagRegistry;
import net.arna.jcraft.api.spec.SpecType;
import net.arna.jcraft.api.spec.SpecTypeUtil;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.api.stand.StandTypeUtil;
import net.arna.jcraft.common.ai.AttackerBrainInfo;
import net.arna.jcraft.common.ai.brain.SpecAttackerBrain;
import net.arna.jcraft.common.ai.brain.StandAttackerBrain;
import net.arna.jcraft.common.ai.brain.StandSpecAttackerBrain;
import net.arna.jcraft.common.config.JServerConfig;
import net.arna.jcraft.common.tickable.TickableHashMap;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;

public class JEnemies {
    private static final TickableHashMap<Mob, AttackerBrainInfo> enemies = new TickableHashMap();

    public static void add(Mob entity) {
        if (entity.m_9236_().m_5776_()) {
            throw new UnsupportedOperationException("Attempted to add an enemy to JEnemies from the clientside!");
        }
        if (entity.m_6095_().m_204039_(JTagRegistry.NO_STAND_USER_AI)) {
            return;
        }
        if (enemies.containsKey(entity)) {
            return;
        }
        JEnemies.add(entity, new AttackerBrainInfo(JServerConfig.BASE_AI_LEVEL.getValue()));
    }

    public static void add(Mob entity, AttackerBrainInfo info) {
        enemies.add(entity, info);
    }

    public static void tick() {
        enemies.tick(iter -> {
            Map.Entry enemyData = (Map.Entry)iter.next();
            Mob mob = (Mob)enemyData.getKey();
            if (mob.m_6084_()) {
                boolean hasStand;
                if (mob.m_21525_()) {
                    return;
                }
                StandType standType = JComponentPlatformUtils.getStandComponent((LivingEntity)mob).getType();
                SpecType specType = JComponentPlatformUtils.getSpecData((LivingEntity)mob).getType();
                AttackerBrainInfo info = (AttackerBrainInfo)enemyData.getValue();
                boolean hasSpec = !SpecTypeUtil.isNone(specType);
                boolean bl = hasStand = !StandTypeUtil.isNone(standType);
                if (hasStand && hasSpec) {
                    StandSpecAttackerBrain.tick(mob, info);
                } else if (hasStand) {
                    StandAttackerBrain.tick(mob, info);
                } else if (hasSpec) {
                    SpecAttackerBrain.tick(mob, info);
                } else {
                    iter.remove();
                }
            } else {
                iter.remove();
            }
        });
    }

    public static boolean contains(Mob mob) {
        return enemies.containsKey(mob);
    }
}

