/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.tickable;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import lombok.NonNull;
import net.arna.jcraft.common.entity.projectile.RazorProjectile;
import net.arna.jcraft.common.network.s2c.MagneticFieldParticlePacket;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MagneticFields {
    private static final List<MagneticField> fields = new ArrayList<MagneticField>();

    public static void tick() {
        for (MagneticField field2 : fields) {
            Entity entity;
            field2.tick();
            if (field2.time % 2 == 0 || !((entity = field2.owner) instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            MagneticFieldParticlePacket.send(serverPlayer, field2.getStrength(), field2.pos);
        }
        fields.removeIf(field -> field.time <= 0);
    }

    public static void forAllOfOwner(@NonNull Entity owner, Consumer<MagneticField> consumer) {
        if (owner == null) {
            throw new NullPointerException("owner is marked non-null but is null");
        }
        for (MagneticField field : fields) {
            if (field.owner != owner || field.level != owner.m_9236_()) continue;
            consumer.accept(field);
        }
    }

    @Nullable
    public static MagneticField nearestOfOwnerTo(@NonNull Entity owner, @NonNull Vec3 pos) {
        if (owner == null) {
            throw new NullPointerException("owner is marked non-null but is null");
        }
        if (pos == null) {
            throw new NullPointerException("pos is marked non-null but is null");
        }
        if (fields.isEmpty()) {
            return null;
        }
        return fields.stream().filter(field -> field.owner == owner).min((a, b) -> {
            double aDist = pos.m_82557_(a.pos);
            double bDist = pos.m_82557_(b.pos);
            return Double.compare(aDist, bDist);
        }).orElse(null);
    }

    @Nullable
    public static MagneticField nearestTo(@NonNull Vec3 pos) {
        if (pos == null) {
            throw new NullPointerException("pos is marked non-null but is null");
        }
        if (fields.isEmpty()) {
            return null;
        }
        return (MagneticField)fields.stream().min((a, b) -> {
            double aDist = pos.m_82557_(a.pos);
            double bDist = pos.m_82557_(b.pos);
            return Double.compare(aDist, bDist);
        }).get();
    }

    public static MagneticField createField(ServerLevel level, Entity owner, Vec3 pos) {
        return MagneticFields.createField(level, owner, pos, 5.0f, 10.0f);
    }

    public static MagneticField createField(ServerLevel level, Entity owner, Vec3 pos, float baseStrength, float peakStrength) {
        MagneticField field = new MagneticField(level, owner, baseStrength, peakStrength, pos);
        fields.add(field);
        return field;
    }

    public static class MagneticField {
        public static final int TICKS_TO_LIVE = 1200;
        public int time = 1200;
        public Vec3 pos;
        private final double baseStrength;
        private final double additiveStrength;
        private final ServerLevel level;
        private final Entity owner;

        MagneticField(ServerLevel level, Entity owner, double baseStrength, double peakStrength, Vec3 pos) {
            this.level = level;
            this.owner = owner;
            this.baseStrength = baseStrength;
            this.additiveStrength = peakStrength - baseStrength;
            this.pos = pos;
        }

        public double getStrength() {
            return this.baseStrength + this.additiveStrength * (double)this.time / 1200.0;
        }

        private void tick() {
            for (Entity entity : this.level.m_8583_()) {
                if (!JUtils.isFerrous(entity) || entity == this.owner) continue;
                double strength = this.getStrength();
                double distanceSqr = entity.m_20238_(this.pos);
                double attraction = (strength - Math.cbrt(distanceSqr)) / 35.0;
                if (entity instanceof RazorProjectile) {
                    attraction /= 2.0;
                }
                if (distanceSqr > strength * strength) {
                    attraction -= Math.sqrt(distanceSqr) / strength;
                }
                if (attraction <= 0.0) continue;
                JUtils.addVelocity(entity, this.pos.m_82546_(entity.m_20182_()).m_82541_().m_82490_(attraction));
            }
            --this.time;
        }
    }
}

