/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.tickable;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.common.util.DimensionData;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class PastDimensions {
    protected static final List<DimensionData> dimensions = new ArrayList<DimensionData>();

    public static void enqueue(DimensionData dimensionData) {
        dimensions.add(dimensionData);
    }

    public static void remove(DimensionData dimensionData) {
        dimensions.remove(dimensionData);
    }

    public static void tick(MinecraftServer server) {
        for (ServerPlayer serverPlayer : JCraft.auWorld.m_6907_()) {
            boolean contained = false;
            for (DimensionData dimensionData : dimensions) {
                if (dimensionData.getUser() != serverPlayer) continue;
                contained = true;
                break;
            }
            if (contained) continue;
            PastDimensions.safeReturn(serverPlayer);
        }
        ArrayList<DimensionData> newDimensions = new ArrayList<DimensionData>();
        for (DimensionData dimensionData : dimensions) {
            LivingEntity user = dimensionData.getUser();
            if (user == null || !user.m_6084_()) continue;
            ServerLevel original = server.m_129880_(dimensionData.getWorldKey());
            if (user.m_9236_() == original) continue;
            dimensionData.decreaseTimer();
            if (dimensionData.getTimer() > 1) {
                newDimensions.add(dimensionData);
                continue;
            }
            Vec3 dimPos = user.m_20182_().m_82520_(0.0, (double)((JCraft.auWorld.m_141928_() - original.m_141928_()) / 2), 0.0);
            if (user instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)user;
                player.m_8999_(original, dimPos.f_82479_, dimPos.f_82480_, dimPos.f_82481_, player.m_146908_(), player.m_146909_());
                continue;
            }
            JCraft.teleportToWorld(user, original, dimPos.f_82479_, dimPos.f_82480_, dimPos.f_82481_);
        }
        if (JCraft.preloadLockTicks <= 0 && newDimensions.isEmpty()) {
            JCraft.clearPreloadedChunks();
        }
        dimensions.clear();
        dimensions.addAll(newDimensions);
    }

    public static void safeReturn(ServerPlayer serverPlayer) {
        JCraft.LOGGER.warn("PastDimensions.safeReturn called on " + String.valueOf(serverPlayer));
        BlockPos spawnPos = serverPlayer.m_8961_();
        if (spawnPos == null) {
            spawnPos = serverPlayer.m_20183_();
        }
        PastDimensions.enqueue(new DimensionData((LivingEntity)serverPlayer, new Vec3((double)spawnPos.m_123341_(), (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_()), (ResourceKey<Level>)serverPlayer.m_8963_()));
    }

    public static boolean tryExit(LivingEntity user, Set<? extends Entity> targets) {
        boolean isStored = false;
        for (DimensionData dimV : dimensions) {
            if (targets.contains(dimV.getUser())) {
                dimV.setTimer(1);
                continue;
            }
            if (dimV.getUser() != user) continue;
            isStored = true;
            dimV.setTimer(1);
        }
        return isStored;
    }
}

