/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.tickable;

import java.util.ArrayList;
import java.util.List;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.registry.JItemRegistry;
import net.arna.jcraft.common.item.Peacemaker;
import net.arna.jcraft.common.util.DimensionData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public final class PeacemakerReload {
    private static final List<DimensionData> toReload = new ArrayList<DimensionData>();
    private static final List<DimensionData> toAdd = new ArrayList<DimensionData>();

    public static void enqueue(DimensionData dimensionData) {
        toAdd.add(dimensionData);
    }

    public static void remove(DimensionData dimensionData) {
        toReload.remove(dimensionData);
    }

    public static void tick(MinecraftServer server) {
        if (!toAdd.isEmpty()) {
            toReload.addAll(toAdd);
            toAdd.clear();
        }
        ArrayList<DimensionData> newToReload = new ArrayList<DimensionData>();
        for (DimensionData toReloadData : toReload) {
            LivingEntity user = toReloadData.getUser();
            if (user == null || !user.m_6084_()) continue;
            int timer = toReloadData.getTimer();
            if (timer > 0) {
                toReloadData.decreaseTimer();
                newToReload.add(toReloadData);
                continue;
            }
            ServerLevel world = server.m_129880_(toReloadData.getWorldKey());
            if (world == null) {
                JCraft.LOGGER.warn("World that toReloadData belongs to no longer exists! Key: " + String.valueOf(toReloadData.getWorldKey()) + " user: " + String.valueOf(user));
                continue;
            }
            ItemStack main = user.m_21205_();
            if (main.m_41720_() != JItemRegistry.PEACEMAKER.get()) continue;
            Peacemaker.finishReload(main, (Level)world, user);
        }
        toReload.clear();
        toReload.addAll(newToReload);
    }

    private PeacemakerReload() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

