/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.tickable;

import net.arna.jcraft.common.entity.projectile.RazorProjectile;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.tickable.TickableHashSet;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;

public class RazorCoughs {
    private static final TickableHashSet<RazorCough> razorCoughs = new TickableHashSet();

    public static void tick() {
        razorCoughs.tick(iter -> {
            int newDuration;
            RazorCough cough = (RazorCough)iter.next();
            if ((newDuration = --cough.duration) == 0) {
                iter.remove();
            } else if (newDuration % 2 == 0 && newDuration <= 20) {
                LivingEntity inflictor = cough.inflictor;
                Entity entity = cough.entity;
                Level entityLevel = entity.m_9236_();
                RazorProjectile razor = new RazorProjectile(entityLevel, inflictor);
                razor.m_146884_(entity.m_20182_().m_82549_(GravityChangerAPI.getEyeOffset(entity)));
                JUtils.shoot((Projectile)razor, entity, entity.m_146909_(), entity.m_146908_(), entityLevel.m_213780_().m_188501_() - 0.5f, 0.5f, 30.0f);
                entityLevel.m_7967_((Entity)razor);
            }
        });
    }

    public static void add(LivingEntity inflictor, Entity inflicted) {
        razorCoughs.add(new RazorCough(40, inflictor, inflicted));
    }

    private static class RazorCough {
        private int duration;
        private final LivingEntity inflictor;
        private final Entity entity;

        public RazorCough(int duration, LivingEntity inflictor, Entity entity) {
            this.duration = duration;
            this.inflictor = inflictor;
            this.entity = entity;
        }
    }
}

