/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.tickable;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class Revivables {
    protected static final List<ReviveData> revivables = new ArrayList<ReviveData>();
    private static final Queue<ReviveData> queuedAdditions = new LinkedList<ReviveData>();
    private static final Queue<ReviveData> queuedRemovals = new LinkedList<ReviveData>();
    private static boolean ticking = false;

    public static void addRevivable(EntityType<?> type, Vec3 pos, ResourceKey<Level> worldKey) {
        ReviveData newReviveData = new ReviveData(type, pos, worldKey);
        if (ticking) {
            queuedAdditions.add(newReviveData);
        } else {
            revivables.add(newReviveData);
        }
    }

    public static void removeRevivable(ReviveData reviveData) {
        if (ticking) {
            queuedRemovals.add(reviveData);
        } else {
            revivables.remove(reviveData);
        }
    }

    public static void revive(@NonNull MinecraftServer server, @NonNull ReviveData revivable) {
        if (server == null) {
            throw new NullPointerException("server is marked non-null but is null");
        }
        if (revivable == null) {
            throw new NullPointerException("revivable is marked non-null but is null");
        }
        ServerLevel serverWorld = server.m_129880_(revivable.worldKey);
        if (serverWorld == null) {
            JCraft.LOGGER.fatal("Tried to revive entity from invalid ServerWorld!");
            return;
        }
        Entity entity = revivable.type.m_20615_((Level)serverWorld);
        if (entity == null) {
            JCraft.LOGGER.warn("Failed to create entity from EntityType: " + String.valueOf(revivable.type));
            return;
        }
        entity.m_146884_(revivable.pos);
        serverWorld.m_7967_(entity);
        Revivables.removeRevivable(revivable);
    }

    public static boolean removeRevivableAt(Vec3 pos) {
        for (ReviveData revivable : revivables) {
            if (revivable.pos != pos) continue;
            return revivables.remove(revivable);
        }
        return false;
    }

    public static List<ReviveData> getAround(Vec3 pos, double distance) {
        ArrayList<ReviveData> out = new ArrayList<ReviveData>();
        for (ReviveData revivable : revivables) {
            if (!(revivable.pos.m_82557_(pos) <= distance * distance)) continue;
            out.add(revivable);
        }
        return out;
    }

    public static void tick(MinecraftServer server) {
        if (ticking) {
            JCraft.LOGGER.error("Tried to tick Revivables while already ticking!");
            return;
        }
        ticking = true;
        revivables.addAll(queuedAdditions);
        revivables.removeAll(queuedRemovals);
        queuedAdditions.clear();
        queuedRemovals.clear();
        ArrayList<ReviveData> newRevivables = new ArrayList<ReviveData>();
        for (ReviveData revivable : revivables) {
            if (--revivable.timer <= 1) continue;
            newRevivables.add(revivable);
        }
        revivables.clear();
        revivables.addAll(newRevivables);
        ticking = false;
    }

    public static class ReviveData {
        @NonNull
        final EntityType<?> type;
        @NonNull
        final Vec3 pos;
        @NonNull
        final ResourceKey<Level> worldKey;
        public int timer = 1200;

        private ReviveData(@NonNull EntityType<?> type, @NonNull Vec3 pos, @NonNull ResourceKey<Level> worldKey) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            if (pos == null) {
                throw new NullPointerException("pos is marked non-null but is null");
            }
            if (worldKey == null) {
                throw new NullPointerException("worldKey is marked non-null but is null");
            }
            this.type = type;
            this.pos = pos;
            this.worldKey = worldKey;
        }

        @NonNull
        public EntityType<?> getType() {
            return this.type;
        }

        @NonNull
        public Vec3 getPos() {
            return this.pos;
        }
    }
}

