/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.tickable;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.function.Consumer;
import net.arna.jcraft.JCraft;
import net.minecraft.util.Tuple;

public class TickableHashMap<K, V> {
    private final HashMap<K, V> map = new HashMap();
    private final Queue<Tuple<K, V>> queue = new LinkedList<Tuple<K, V>>();
    private boolean ticking = false;

    public void add(K key, V value) {
        if (this.ticking) {
            this.queue.add(new Tuple(key, value));
            return;
        }
        this.map.put(key, value);
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public V get(Object key) {
        return this.map.get(key);
    }

    public void tick(Consumer<Iterator<Map.Entry<K, V>>> consumer) {
        if (this.ticking) {
            JCraft.LOGGER.error("Tried to tick TickableHashMap while already ticking!");
            return;
        }
        while (!this.queue.isEmpty()) {
            Tuple<K, V> newEntry = this.queue.poll();
            this.map.put(newEntry.m_14418_(), newEntry.m_14419_());
        }
        this.ticking = true;
        Iterator<Map.Entry<K, V>> i = this.map.entrySet().iterator();
        while (i.hasNext()) {
            consumer.accept(i);
        }
        this.ticking = false;
    }
}

