/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.tickable;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.function.Consumer;
import net.arna.jcraft.JCraft;

public class TickableHashSet<T> {
    private final HashSet<T> set = new HashSet();
    private final Queue<T> queue = new LinkedList<T>();
    private boolean ticking = false;

    public void add(T key) {
        if (this.ticking) {
            this.queue.add(key);
            return;
        }
        this.set.add(key);
    }

    public boolean contains(Object key) {
        return this.set.contains(key);
    }

    public int size() {
        return this.set.size();
    }

    public void tick(Consumer<Iterator<T>> consumer) {
        if (this.ticking) {
            JCraft.LOGGER.error("Tried to tick TickableHashSet while already ticking!");
            return;
        }
        while (!this.queue.isEmpty()) {
            T newItem = this.queue.poll();
            this.set.add(newItem);
        }
        this.ticking = true;
        Iterator<T> i = this.set.iterator();
        while (i.hasNext()) {
            consumer.accept(i);
        }
        this.ticking = false;
    }
}

