/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.tickable;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.component.living.CommonStandComponent;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.entity.stand.GEREntity;
import net.arna.jcraft.common.entity.stand.KingCrimsonEntity;
import net.arna.jcraft.common.util.DimensionData;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Timestops {
    protected static final List<DimensionData> TIMESTOPS = new ArrayList<DimensionData>();
    public static final Predicate<Entity> TIMESTOP_PREDICATE = entity -> {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (entity.m_5833_()) {
                return false;
            }
            if (player.m_7500_()) {
                return false;
            }
        }
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            StandEntity<?, ?> stand = null;
            if (living instanceof StandEntity) {
                StandEntity<?, ?> livingStand;
                stand = livingStand = (StandEntity<?, ?>)living;
            } else {
                CommonStandComponent standComponent = JComponentPlatformUtils.getStandComponent(living);
                if (standComponent.getStand() != null) {
                    stand = standComponent.getStand();
                }
            }
            if (stand != null) {
                GEREntity requiem;
                KingCrimsonEntity kingCrimson;
                if (stand instanceof KingCrimsonEntity && (kingCrimson = (KingCrimsonEntity)stand).getTETime() > 0) {
                    return false;
                }
                if (stand instanceof GEREntity && (requiem = (GEREntity)stand).getState() == GEREntity.State.COUNTER) {
                    return false;
                }
            }
        }
        return true;
    };

    public static void enqueue(DimensionData dimensionData) {
        TIMESTOPS.add(dimensionData);
    }

    public static void remove(DimensionData dimensionData) {
        TIMESTOPS.remove(dimensionData);
    }

    public static void tick(MinecraftServer server) {
        ArrayList<DimensionData> newActiveTimestops = new ArrayList<DimensionData>();
        for (DimensionData timestop : TIMESTOPS) {
            LivingEntity user = timestop.getUser();
            int timer = timestop.getTimer();
            if (user == null || !user.m_6084_() || timer <= 0) continue;
            timestop.decreaseTimer();
            ServerLevel world = server.m_129880_(timestop.getWorldKey());
            if (world == null) {
                JCraft.LOGGER.warn("World that timestop belongs to no longer exists! Key: " + String.valueOf(timestop.getWorldKey()) + " Timestopper: " + String.valueOf(user));
                continue;
            }
            Vec3 pos = timestop.getPos();
            List toStop = world.m_6443_(Entity.class, new AABB(pos.m_82520_(96.0, 96.0, 96.0), pos.m_82492_(96.0, 96.0, 96.0)), TIMESTOP_PREDICATE);
            for (Entity entity : toStop) {
                LivingEntity living;
                if (entity.m_20159_() || entity == user || entity instanceof LivingEntity && entity == JUtils.getStand(living = (LivingEntity)entity) || entity == user.m_20202_() || !JComponentPlatformUtils.getTimeStopData(entity).isPresent()) continue;
                JComponentPlatformUtils.getTimeStopData(entity).get().setTicks(2);
            }
            newActiveTimestops.add(timestop);
        }
        TIMESTOPS.clear();
        TIMESTOPS.addAll(newActiveTimestops);
    }

    public static boolean isInTSRange(Vec3 pos) {
        for (DimensionData timeStop : TIMESTOPS) {
            if (timeStop == null || !(timeStop.getPos().m_82531_(pos.m_7096_(), pos.m_7098_(), pos.m_7094_()) <= 65536.0)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInTSRange(BlockPos pos) {
        for (DimensionData timeStop : TIMESTOPS) {
            if (timeStop == null || !(timeStop.getPos().m_82531_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) <= 65536.0)) continue;
            return true;
        }
        return false;
    }

    public static int getTicksIfInTSRange(BlockPos pos) {
        for (DimensionData timeStop : TIMESTOPS) {
            if (timeStop == null || !(timeStop.getUser().m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) <= 65536.0)) continue;
            return timeStop.getTimer();
        }
        return 0;
    }

    @Nullable
    public static DimensionData getTimestop(Entity entity) {
        for (DimensionData data : TIMESTOPS) {
            if (data.getUser() != entity) continue;
            return data;
        }
        return null;
    }
}

