/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.util;

import com.mojang.serialization.Codec;
import net.arna.jcraft.common.util.JCodecUtils;

public enum CooldownType {
    STAND_LIGHT,
    STAND_HEAVY,
    STAND_BARRAGE(true),
    STAND_SP1,
    STAND_SP2,
    STAND_SP3,
    STAND_ULTIMATE(Category.STAND, true, true),
    STAND_STANDBY,
    STAND_TOSS,
    HEAVY(Category.SPEC),
    BARRAGE(Category.SPEC, true),
    SPECIAL1(Category.SPEC),
    SPECIAL2(Category.SPEC),
    SPECIAL3(Category.SPEC),
    ULTIMATE(Category.SPEC, true, true),
    UTILITY(Category.UNIVERSAL),
    COMBO_BREAKER(Category.UNIVERSAL, 1200, true, true),
    COOLDOWN_CANCEL(Category.UNIVERSAL, 900, true, true),
    DASH(Category.UNIVERSAL, 40, true, true);

    public static final Codec<CooldownType> CODEC;
    private final Category category;
    private final int duration;
    private final boolean nonResettable;
    private final boolean overrideNoCooldowns;

    private CooldownType() {
        this(-1);
    }

    private CooldownType(int duration) {
        this(duration, false);
    }

    private CooldownType(Category category) {
        this(category, -1, false, false);
    }

    private CooldownType(boolean nonResettable) {
        this(-1, nonResettable);
    }

    private CooldownType(Category category, boolean nonResettable) {
        this(category, -1, nonResettable, false);
    }

    private CooldownType(int duration, boolean nonResettable) {
        this(Category.STAND, duration, nonResettable, false);
    }

    private CooldownType(Category category, boolean nonResettable, boolean overrideNoCooldowns) {
        this(category, -1, nonResettable, overrideNoCooldowns);
    }

    private CooldownType(Category category, int duration, boolean nonResettable, boolean overrideNoCooldowns) {
        this.category = category;
        this.duration = duration;
        this.nonResettable = nonResettable;
        this.overrideNoCooldowns = overrideNoCooldowns;
    }

    public Category getCategory() {
        return this.category;
    }

    public int getDuration() {
        return this.duration;
    }

    public boolean isNonResettable() {
        return this.nonResettable;
    }

    public boolean isOverrideNoCooldowns() {
        return this.overrideNoCooldowns;
    }

    static {
        CODEC = JCodecUtils.createEnumCodec(CooldownType.class);
    }

    public static enum Category {
        STAND,
        SPEC,
        UNIVERSAL;

    }
}

