/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.util;

import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.component.living.CommonCooldownsComponent;
import net.arna.jcraft.api.registry.JSpecTypeRegistry;
import net.arna.jcraft.api.registry.JStatRegistry;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.api.spec.JSpec;
import net.arna.jcraft.common.network.s2c.PlayerAnimPacket;
import net.arna.jcraft.common.util.CooldownType;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class DashData {
    public final Vec3 dashVector;
    public final LivingEntity entity;
    public boolean finished = false;
    private int duration = 10;

    public DashData(Vec3 dashVector, LivingEntity entity) {
        this.dashVector = dashVector;
        this.entity = entity;
    }

    public void tickDash() {
        --this.duration;
        if (this.entity.m_21023_((MobEffect)JStatusRegistry.DAZED.get())) {
            this.finished = true;
            return;
        }
        if (this.duration <= 5) {
            if (this.duration <= 0) {
                this.finished = true;
            }
            return;
        }
        this.entity.m_20256_(this.entity.m_20184_().m_82549_(this.dashVector).m_82490_(0.5));
        this.entity.f_19864_ = true;
    }

    public static boolean isDashing(LivingEntity entity) {
        return JCraft.dashes.containsKey(entity);
    }

    public static DashData getDash(LivingEntity entity) {
        return JCraft.dashes.get(entity);
    }

    public static void tryDash(int forward, int side, LivingEntity entity) {
        CommonCooldownsComponent cooldowns = JComponentPlatformUtils.getCooldowns(entity);
        if (cooldowns.getCooldown(CooldownType.DASH) > 0 || !entity.m_20096_() || entity.m_21023_((MobEffect)JStatusRegistry.DAZED.get()) || entity.m_21023_((MobEffect)JStatusRegistry.KNOCKDOWN.get())) {
            return;
        }
        cooldowns.setCooldown(CooldownType.DASH, 40);
        double dashSpeed = 0.75;
        Vec3 rotVec = Vec3.m_82498_((float)entity.m_146909_(), (float)entity.m_146908_());
        rotVec = rotVec.m_82524_(1.5707964f * (float)side);
        if (side != 0) {
            dashSpeed *= 0.75;
            if (forward == 1) {
                rotVec = rotVec.m_82524_(-0.7853982f * (float)side);
            }
        }
        if (forward == -1) {
            rotVec = rotVec.m_82524_(side == 0 ? (float)Math.PI : 0.7853982f * (float)side);
            dashSpeed *= 0.75;
        }
        JCraft.dashes.put(entity, new DashData(rotVec.m_82541_().m_82490_(dashSpeed), entity));
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.m_36220_((ResourceLocation)JStatRegistry.DASHES.get());
            JSpec<?, ?> spec = JUtils.getSpec((LivingEntity)player);
            if (spec == null || spec.moveStun < 1) {
                Object dashAnim;
                Object object = dashAnim = forward >= 0 ? "dash" : "bdash";
                if (spec != null && spec.getType() == JSpecTypeRegistry.VAMPIRE.get()) {
                    dashAnim = "vm." + (String)dashAnim;
                }
                for (ServerPlayer recipient : JUtils.around((ServerLevel)entity.m_9236_(), entity.m_20182_(), 96.0)) {
                    PlayerAnimPacket.send((Player)player, recipient, (String)dashAnim);
                }
            }
        }
    }
}

