/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.util;

import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class DimensionData {
    private final LivingEntity user;
    @Nullable
    private Vec3 pos = null;
    private final ResourceKey<Level> worldKey;
    private int timer = 300;

    public DimensionData(LivingEntity user, ResourceKey<Level> worldKey, int timer) {
        this.user = user;
        this.worldKey = worldKey;
        this.timer = timer;
    }

    public DimensionData(LivingEntity user, @Nullable Vec3 pos, ResourceKey<Level> worldKey) {
        this.user = user;
        this.pos = pos;
        this.worldKey = worldKey;
    }

    public DimensionData(LivingEntity user, @Nullable Vec3 pos, ResourceKey<Level> worldKey, int timer) {
        this.user = user;
        this.pos = pos;
        this.worldKey = worldKey;
        this.timer = timer;
    }

    public void decreaseTimer() {
        --this.timer;
    }

    public LivingEntity getUser() {
        return this.user;
    }

    @Nullable
    public Vec3 getPos() {
        return this.pos;
    }

    public ResourceKey<Level> getWorldKey() {
        return this.worldKey;
    }

    public int getTimer() {
        return this.timer;
    }

    public void setPos(@Nullable Vec3 pos) {
        this.pos = pos;
    }

    public void setTimer(int timer) {
        this.timer = timer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DimensionData)) {
            return false;
        }
        DimensionData other = (DimensionData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimer() != other.getTimer()) {
            return false;
        }
        LivingEntity this$user = this.getUser();
        LivingEntity other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        Vec3 this$pos = this.getPos();
        Vec3 other$pos = other.getPos();
        if (this$pos == null ? other$pos != null : !this$pos.equals(other$pos)) {
            return false;
        }
        ResourceKey<Level> this$worldKey = this.getWorldKey();
        ResourceKey<Level> other$worldKey = other.getWorldKey();
        return !(this$worldKey == null ? other$worldKey != null : !this$worldKey.equals(other$worldKey));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DimensionData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTimer();
        LivingEntity $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        Vec3 $pos = this.getPos();
        result = result * 59 + ($pos == null ? 43 : $pos.hashCode());
        ResourceKey<Level> $worldKey = this.getWorldKey();
        result = result * 59 + ($worldKey == null ? 43 : $worldKey.hashCode());
        return result;
    }

    public String toString() {
        return "DimensionData(user=" + String.valueOf(this.getUser()) + ", pos=" + String.valueOf(this.getPos()) + ", worldKey=" + String.valueOf(this.getWorldKey()) + ", timer=" + this.getTimer() + ")";
    }
}

