/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.event.CompoundEventResult;
import dev.architectury.event.events.common.InteractionEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.JRegistries;
import net.arna.jcraft.api.component.living.CommonStandComponent;
import net.arna.jcraft.api.registry.JStatRegistry;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.common.saveddata.ExclusiveStandsData;
import net.arna.jcraft.common.util.JCodecUtils;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class EvolutionItemHandler {
    private static final Multimap<Item, Evolution> evolutions = MultimapBuilder.hashKeys().arrayListValues().build();

    public static void init() {
    }

    public static List<Evolution> getEvolutions() {
        return ImmutableList.copyOf((Collection)evolutions.values());
    }

    private static CompoundEventResult<ItemStack> onItemUse(Player player, InteractionHand hand) {
        Evolution fallback;
        if (player.m_9236_().m_5776_()) {
            return CompoundEventResult.pass();
        }
        ItemStack handStack = player.m_21120_(hand);
        Item item = handStack.m_41720_();
        ExclusiveStandsData exclusiveStands = JCraft.getExclusiveStandsData();
        if (!evolutions.containsKey((Object)item)) {
            return CompoundEventResult.pass();
        }
        Collection evolutions = EvolutionItemHandler.evolutions.get((Object)item);
        CommonStandComponent standData = JComponentPlatformUtils.getStandComponent((LivingEntity)player);
        StandType current = standData.getType();
        Evolution evolution = fallback = (Evolution)evolutions.stream().filter(e -> e.predicate().m_45049_(handStack) && e.stand() == null).findFirst().orElse(null);
        if (current != null) {
            evolution = evolutions.stream().filter(e -> e.predicate().m_45049_(handStack) && e.stand() == current).findFirst().orElse(fallback);
        }
        if (evolution == null) {
            return CompoundEventResult.pass();
        }
        if (exclusiveStands.isStandUsed(evolution.target())) {
            return CompoundEventResult.pass();
        }
        if (!player.m_7500_()) {
            handStack.m_41774_(1);
        }
        standData.setTypeAndSkin(evolution.target(), standData.getSkin());
        player.m_36220_((ResourceLocation)JStatRegistry.STAND_EVOLVED.get());
        StandEntity<?, ?> stand = standData.getStand();
        if (stand != null) {
            stand.desummon();
        }
        JCraft.summon(player.m_9236_(), (LivingEntity)player);
        return CompoundEventResult.interruptTrue((Object)handStack);
    }

    public static CompletableFuture<Void> onReload(PreparableReloadListener.PreparationBarrier preparationBarrier, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> EvolutionItemHandler.readEvolutions(resourceManager), backgroundExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)preparationBarrier).m_6769_(arg_0))).thenAccept(evs -> evs.forEach(e -> evolutions.put((Object)e.item(), e)));
    }

    private static Collection<Evolution> readEvolutions(ResourceManager resourceManager) {
        Map evolutionFiles = resourceManager.m_214159_("evolutions", rl -> rl.m_135815_().endsWith(".json"));
        Gson gson = new Gson();
        ArrayList<Evolution> evolutions = new ArrayList<Evolution>();
        for (Map.Entry entry : evolutionFiles.entrySet()) {
            JsonObject obj;
            try (BufferedReader reader = ((Resource)entry.getValue()).m_215508_();){
                obj = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            }
            catch (IOException e) {
                JCraft.LOGGER.error("Failed to read evolutions from {}", entry.getKey(), (Object)e);
                continue;
            }
            Either res = Evolution.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)obj).get();
            res.ifLeft(evolutions::add);
            res.ifRight(err -> JCraft.LOGGER.error("Failed to parse evolutions from {}: {}", entry.getKey(), (Object)err.message()));
        }
        return evolutions;
    }

    static {
        InteractionEvent.RIGHT_CLICK_ITEM.register(EvolutionItemHandler::onItemUse);
    }

    public record Evolution(Item item, ItemPredicate predicate, @Nullable StandType stand, StandType target) {
        public static final Codec<Evolution> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_257033_.m_194605_().fieldOf("item").forGetter(Evolution::item), (App)JCodecUtils.ITEM_PREDICATE_CODEC.optionalFieldOf("predicate", (Object)ItemPredicate.f_45028_).forGetter(Evolution::predicate), (App)JRegistries.STAND_TYPE_CODEC.optionalFieldOf("stand").forGetter(e -> Optional.ofNullable(e.stand())), (App)JRegistries.STAND_TYPE_CODEC.fieldOf("target").forGetter(Evolution::target)).apply((Applicative)instance, Evolution::new));

        public Evolution(Item item, @Nullable StandType stand, StandType target) {
            this(item, ItemPredicate.f_45028_, stand, target);
        }

        private Evolution(Item item, ItemPredicate predicate, Optional<StandType> stand, StandType target) {
            this(item, predicate, (StandType)stand.orElse(null), target);
        }
    }
}

