/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.util;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.kinds.K1;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.effect.MobEffectInstance;

public class JCodecUtils {
    public static final Codec<MobEffectInstance> MOB_EFFECT_INSTANCE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_256974_.m_194605_().fieldOf("effect").forGetter(MobEffectInstance::m_19544_), (App)Codec.INT.fieldOf("duration").forGetter(MobEffectInstance::m_19557_), (App)Codec.INT.fieldOf("amplifier").forGetter(MobEffectInstance::m_19564_), (App)Codec.BOOL.optionalFieldOf("ambient", (Object)false).forGetter(MobEffectInstance::m_19571_), (App)Codec.BOOL.optionalFieldOf("visible", (Object)true).forGetter(MobEffectInstance::m_19572_), (App)Codec.BOOL.optionalFieldOf("show_icon", (Object)true).forGetter(MobEffectInstance::m_19575_)).apply((Applicative)instance, MobEffectInstance::new));
    public static final Codec<Supplier<SoundEvent>> SOUND_EVENT_SUPPLIER_CODEC = ResourceLocation.f_135803_.xmap(loc -> () -> (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(loc), s -> {
        ResourceLocation resourceLocation;
        if (s instanceof RegistrySupplier) {
            RegistrySupplier rs = (RegistrySupplier)s;
            resourceLocation = rs.getId();
        } else {
            resourceLocation = BuiltInRegistries.f_256894_.m_7981_((Object)((SoundEvent)s.get()));
        }
        return resourceLocation;
    });
    public static final Codec<ItemPredicate> ITEM_PREDICATE_CODEC = ExtraCodecs.f_252400_.comapFlatMap(input -> {
        try {
            return DataResult.success((Object)ItemPredicate.m_45051_((JsonElement)input));
        }
        catch (JsonParseException e) {
            return DataResult.error(() -> "Failed to parse item predicate: " + e.getMessage());
        }
    }, ItemPredicate::m_45048_);

    public static <E extends Enum<?>> Codec<E> createEnumCodec(Class<E> enumClass) {
        Map constants = (Map)Stream.of((Enum[])enumClass.getEnumConstants()).collect(ImmutableMap.toImmutableMap(Enum::name, e -> e));
        return Codec.STRING.comapFlatMap(DataResult.partialGet(constants::get, () -> "Unknown enum constant: "), Enum::name);
    }

    public static <O, T> Function<O, Optional<T>> optional(Function<O, T> f, T defaultValue) {
        return o -> {
            Object result = f.apply(o);
            return Objects.equals(result, defaultValue) ? Optional.empty() : Optional.ofNullable(result);
        };
    }

    public static <F extends K1, T1, T2, T3, T4, T5, T6, T7, T8, T9> Products.P9<F, T1, T2, T3, T4, T5, T6, T7, T8, T9> and(Products.P1<F, T1> p1, Products.P8<F, T2, T3, T4, T5, T6, T7, T8, T9> p2) {
        return new Products.P9(p1.t1(), p2.t1(), p2.t2(), p2.t3(), p2.t4(), p2.t5(), p2.t6(), p2.t7(), p2.t8());
    }

    public static <F extends K1, T1, T2, T3, T4, T5, T6, T7, T8, T9> Products.P9<F, T1, T2, T3, T4, T5, T6, T7, T8, T9> and(Products.P2<F, T1, T2> p1, Products.P7<F, T3, T4, T5, T6, T7, T8, T9> p2) {
        return new Products.P9(p1.t1(), p1.t2(), p2.t1(), p2.t2(), p2.t3(), p2.t4(), p2.t5(), p2.t6(), p2.t7());
    }

    public static <F extends K1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> Products.P10<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> and(Products.P2<F, T1, T2> p1, Products.P8<F, T3, T4, T5, T6, T7, T8, T9, T10> p2) {
        return new Products.P10(p1.t1(), p1.t2(), p2.t1(), p2.t2(), p2.t3(), p2.t4(), p2.t5(), p2.t6(), p2.t7(), p2.t8());
    }

    public static <F extends K1, T1, T2, T3, T4, T5, T6, T7, T8, T9> Products.P9<F, T1, T2, T3, T4, T5, T6, T7, T8, T9> and(Products.P3<F, T1, T2, T3> p1, Products.P6<F, T4, T5, T6, T7, T8, T9> p2) {
        return new Products.P9(p1.t1(), p1.t2(), p1.t3(), p2.t1(), p2.t2(), p2.t3(), p2.t4(), p2.t5(), p2.t6());
    }

    public static <F extends K1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> Products.P10<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> and(Products.P3<F, T1, T2, T3> p1, Products.P7<F, T4, T5, T6, T7, T8, T9, T10> p2) {
        return new Products.P10(p1.t1(), p1.t2(), p1.t3(), p2.t1(), p2.t2(), p2.t3(), p2.t4(), p2.t5(), p2.t6(), p2.t7());
    }

    public static <F extends K1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> Products.P11<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> and(Products.P3<F, T1, T2, T3> p1, Products.P8<F, T4, T5, T6, T7, T8, T9, T10, T11> p2) {
        return new Products.P11(p1.t1(), p1.t2(), p1.t3(), p2.t1(), p2.t2(), p2.t3(), p2.t4(), p2.t5(), p2.t6(), p2.t7(), p2.t8());
    }

    public static <F extends K1, T1, T2, T3, T4, T5, T6, T7, T8, T9> Products.P9<F, T1, T2, T3, T4, T5, T6, T7, T8, T9> and(Products.P4<F, T1, T2, T3, T4> p1, Products.P5<F, T5, T6, T7, T8, T9> p2) {
        return new Products.P9(p1.t1(), p1.t2(), p1.t3(), p1.t4(), p2.t1(), p2.t2(), p2.t3(), p2.t4(), p2.t5());
    }

    public static <F extends K1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> Products.P10<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> and(Products.P4<F, T1, T2, T3, T4> p1, Products.P6<F, T5, T6, T7, T8, T9, T10> p2) {
        return new Products.P10(p1.t1(), p1.t2(), p1.t3(), p1.t4(), p2.t1(), p2.t2(), p2.t3(), p2.t4(), p2.t5(), p2.t6());
    }

    public static <F extends K1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> Products.P11<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> and(Products.P4<F, T1, T2, T3, T4> p1, Products.P7<F, T5, T6, T7, T8, T9, T10, T11> p2) {
        return new Products.P11(p1.t1(), p1.t2(), p1.t3(), p1.t4(), p2.t1(), p2.t2(), p2.t3(), p2.t4(), p2.t5(), p2.t6(), p2.t7());
    }

    public static <F extends K1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> Products.P12<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> and(Products.P4<F, T1, T2, T3, T4> p1, Products.P8<F, T5, T6, T7, T8, T9, T10, T11, T12> p2) {
        return new Products.P12(p1.t1(), p1.t2(), p1.t3(), p1.t4(), p2.t1(), p2.t2(), p2.t3(), p2.t4(), p2.t5(), p2.t6(), p2.t7(), p2.t8());
    }

    public static <F extends K1, T1, T2, T3, T4, T5, T6, T7, T8, T9> Products.P9<F, T1, T2, T3, T4, T5, T6, T7, T8, T9> and(Products.P5<F, T1, T2, T3, T4, T5> p1, Products.P4<F, T6, T7, T8, T9> p2) {
        return new Products.P9(p1.t1(), p1.t2(), p1.t3(), p1.t4(), p1.t5(), p2.t1(), p2.t2(), p2.t3(), p2.t4());
    }

    public static <F extends K1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> Products.P10<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> and(Products.P5<F, T1, T2, T3, T4, T5> p1, Products.P5<F, T6, T7, T8, T9, T10> p2) {
        return new Products.P10(p1.t1(), p1.t2(), p1.t3(), p1.t4(), p1.t5(), p2.t1(), p2.t2(), p2.t3(), p2.t4(), p2.t5());
    }

    public static <F extends K1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> Products.P11<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> and(Products.P5<F, T1, T2, T3, T4, T5> p1, Products.P6<F, T6, T7, T8, T9, T10, T11> p2) {
        return new Products.P11(p1.t1(), p1.t2(), p1.t3(), p1.t4(), p1.t5(), p2.t1(), p2.t2(), p2.t3(), p2.t4(), p2.t5(), p2.t6());
    }

    public static <F extends K1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> Products.P12<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> and(Products.P5<F, T1, T2, T3, T4, T5> p1, Products.P7<F, T6, T7, T8, T9, T10, T11, T12> p2) {
        return new Products.P12(p1.t1(), p1.t2(), p1.t3(), p1.t4(), p1.t5(), p2.t1(), p2.t2(), p2.t3(), p2.t4(), p2.t5(), p2.t6(), p2.t7());
    }

    public static <F extends K1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> Products.P13<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> and(Products.P5<F, T1, T2, T3, T4, T5> p1, Products.P8<F, T6, T7, T8, T9, T10, T11, T12, T13> p2) {
        return new Products.P13(p1.t1(), p1.t2(), p1.t3(), p1.t4(), p1.t5(), p2.t1(), p2.t2(), p2.t3(), p2.t4(), p2.t5(), p2.t6(), p2.t7(), p2.t8());
    }

    public static <F extends K1, T1, T2, T3, T4, T5, T6, T7, T8, T9> Products.P9<F, T1, T2, T3, T4, T5, T6, T7, T8, T9> and(Products.P6<F, T1, T2, T3, T4, T5, T6> p1, Products.P3<F, T7, T8, T9> p2) {
        return new Products.P9(p1.t1(), p1.t2(), p1.t3(), p1.t4(), p1.t5(), p1.t6(), p2.t1(), p2.t2(), p2.t3());
    }

    public static <F extends K1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> Products.P10<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> and(Products.P6<F, T1, T2, T3, T4, T5, T6> p1, Products.P4<F, T7, T8, T9, T10> p2) {
        return new Products.P10(p1.t1(), p1.t2(), p1.t3(), p1.t4(), p1.t5(), p1.t6(), p2.t1(), p2.t2(), p2.t3(), p2.t4());
    }

    public static <F extends K1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> Products.P11<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> and(Products.P6<F, T1, T2, T3, T4, T5, T6> p1, Products.P5<F, T7, T8, T9, T10, T11> p2) {
        return new Products.P11(p1.t1(), p1.t2(), p1.t3(), p1.t4(), p1.t5(), p1.t6(), p2.t1(), p2.t2(), p2.t3(), p2.t4(), p2.t5());
    }

    public static <F extends K1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> Products.P12<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> and(Products.P6<F, T1, T2, T3, T4, T5, T6> p1, Products.P6<F, T7, T8, T9, T10, T11, T12> p2) {
        return new Products.P12(p1.t1(), p1.t2(), p1.t3(), p1.t4(), p1.t5(), p1.t6(), p2.t1(), p2.t2(), p2.t3(), p2.t4(), p2.t5(), p2.t6());
    }

    public static <F extends K1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> Products.P13<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> and(Products.P6<F, T1, T2, T3, T4, T5, T6> p1, Products.P7<F, T7, T8, T9, T10, T11, T12, T13> p2) {
        return new Products.P13(p1.t1(), p1.t2(), p1.t3(), p1.t4(), p1.t5(), p1.t6(), p2.t1(), p2.t2(), p2.t3(), p2.t4(), p2.t5(), p2.t6(), p2.t7());
    }

    public static <F extends K1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> Products.P14<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> and(Products.P6<F, T1, T2, T3, T4, T5, T6> p1, Products.P8<F, T7, T8, T9, T10, T11, T12, T13, T14> p2) {
        return new Products.P14(p1.t1(), p1.t2(), p1.t3(), p1.t4(), p1.t5(), p1.t6(), p2.t1(), p2.t2(), p2.t3(), p2.t4(), p2.t5(), p2.t6(), p2.t7(), p2.t8());
    }

    public static <F extends K1, T1, T2, T3, T4, T5, T6, T7, T8, T9> Products.P9<F, T1, T2, T3, T4, T5, T6, T7, T8, T9> and(Products.P7<F, T1, T2, T3, T4, T5, T6, T7> p1, Products.P2<F, T8, T9> p2) {
        return new Products.P9(p1.t1(), p1.t2(), p1.t3(), p1.t4(), p1.t5(), p1.t6(), p1.t7(), p2.t1(), p2.t2());
    }

    public static <F extends K1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> Products.P10<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> and(Products.P7<F, T1, T2, T3, T4, T5, T6, T7> p1, Products.P3<F, T8, T9, T10> p2) {
        return new Products.P10(p1.t1(), p1.t2(), p1.t3(), p1.t4(), p1.t5(), p1.t6(), p1.t7(), p2.t1(), p2.t2(), p2.t3());
    }

    public static <F extends K1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> Products.P11<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> and(Products.P7<F, T1, T2, T3, T4, T5, T6, T7> p1, Products.P4<F, T8, T9, T10, T11> p2) {
        return new Products.P11(p1.t1(), p1.t2(), p1.t3(), p1.t4(), p1.t5(), p1.t6(), p1.t7(), p2.t1(), p2.t2(), p2.t3(), p2.t4());
    }

    public static <F extends K1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> Products.P12<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> and(Products.P7<F, T1, T2, T3, T4, T5, T6, T7> p1, Products.P5<F, T8, T9, T10, T11, T12> p2) {
        return new Products.P12(p1.t1(), p1.t2(), p1.t3(), p1.t4(), p1.t5(), p1.t6(), p1.t7(), p2.t1(), p2.t2(), p2.t3(), p2.t4(), p2.t5());
    }

    public static <F extends K1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> Products.P13<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> and(Products.P7<F, T1, T2, T3, T4, T5, T6, T7> p1, Products.P6<F, T8, T9, T10, T11, T12, T13> p2) {
        return new Products.P13(p1.t1(), p1.t2(), p1.t3(), p1.t4(), p1.t5(), p1.t6(), p1.t7(), p2.t1(), p2.t2(), p2.t3(), p2.t4(), p2.t5(), p2.t6());
    }

    public static <F extends K1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> Products.P14<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> and(Products.P7<F, T1, T2, T3, T4, T5, T6, T7> p1, Products.P7<F, T8, T9, T10, T11, T12, T13, T14> p2) {
        return new Products.P14(p1.t1(), p1.t2(), p1.t3(), p1.t4(), p1.t5(), p1.t6(), p1.t7(), p2.t1(), p2.t2(), p2.t3(), p2.t4(), p2.t5(), p2.t6(), p2.t7());
    }

    public static <F extends K1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> Products.P15<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> and(Products.P7<F, T1, T2, T3, T4, T5, T6, T7> p1, Products.P8<F, T8, T9, T10, T11, T12, T13, T14, T15> p2) {
        return new Products.P15(p1.t1(), p1.t2(), p1.t3(), p1.t4(), p1.t5(), p1.t6(), p1.t7(), p2.t1(), p2.t2(), p2.t3(), p2.t4(), p2.t5(), p2.t6(), p2.t7(), p2.t8());
    }

    public static <F extends K1, T1, T2, T3, T4, T5, T6, T7, T8, T9> Products.P9<F, T1, T2, T3, T4, T5, T6, T7, T8, T9> and(Products.P8<F, T1, T2, T3, T4, T5, T6, T7, T8> p1, Products.P1<F, T9> p2) {
        return new Products.P9(p1.t1(), p1.t2(), p1.t3(), p1.t4(), p1.t5(), p1.t6(), p1.t7(), p1.t8(), p2.t1());
    }

    public static <F extends K1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> Products.P10<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> and(Products.P8<F, T1, T2, T3, T4, T5, T6, T7, T8> p1, Products.P2<F, T9, T10> p2) {
        return new Products.P10(p1.t1(), p1.t2(), p1.t3(), p1.t4(), p1.t5(), p1.t6(), p1.t7(), p1.t8(), p2.t1(), p2.t2());
    }

    public static <F extends K1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> Products.P11<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> and(Products.P8<F, T1, T2, T3, T4, T5, T6, T7, T8> p1, Products.P3<F, T9, T10, T11> p2) {
        return new Products.P11(p1.t1(), p1.t2(), p1.t3(), p1.t4(), p1.t5(), p1.t6(), p1.t7(), p1.t8(), p2.t1(), p2.t2(), p2.t3());
    }

    public static <F extends K1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> Products.P12<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> and(Products.P8<F, T1, T2, T3, T4, T5, T6, T7, T8> p1, Products.P4<F, T9, T10, T11, T12> p2) {
        return new Products.P12(p1.t1(), p1.t2(), p1.t3(), p1.t4(), p1.t5(), p1.t6(), p1.t7(), p1.t8(), p2.t1(), p2.t2(), p2.t3(), p2.t4());
    }

    public static <F extends K1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> Products.P13<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> and(Products.P8<F, T1, T2, T3, T4, T5, T6, T7, T8> p1, Products.P5<F, T9, T10, T11, T12, T13> p2) {
        return new Products.P13(p1.t1(), p1.t2(), p1.t3(), p1.t4(), p1.t5(), p1.t6(), p1.t7(), p1.t8(), p2.t1(), p2.t2(), p2.t3(), p2.t4(), p2.t5());
    }

    public static <F extends K1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> Products.P14<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> and(Products.P8<F, T1, T2, T3, T4, T5, T6, T7, T8> p1, Products.P6<F, T9, T10, T11, T12, T13, T14> p2) {
        return new Products.P14(p1.t1(), p1.t2(), p1.t3(), p1.t4(), p1.t5(), p1.t6(), p1.t7(), p1.t8(), p2.t1(), p2.t2(), p2.t3(), p2.t4(), p2.t5(), p2.t6());
    }

    public static <F extends K1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> Products.P15<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> and(Products.P8<F, T1, T2, T3, T4, T5, T6, T7, T8> p1, Products.P7<F, T9, T10, T11, T12, T13, T14, T15> p2) {
        return new Products.P15(p1.t1(), p1.t2(), p1.t3(), p1.t4(), p1.t5(), p1.t6(), p1.t7(), p1.t8(), p2.t1(), p2.t2(), p2.t3(), p2.t4(), p2.t5(), p2.t6(), p2.t7());
    }

    public static <F extends K1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16> Products.P16<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16> and(Products.P8<F, T1, T2, T3, T4, T5, T6, T7, T8> p1, Products.P8<F, T9, T10, T11, T12, T13, T14, T15, T16> p2) {
        return new Products.P16(p1.t1(), p1.t2(), p1.t3(), p1.t4(), p1.t5(), p1.t6(), p1.t7(), p1.t8(), p2.t1(), p2.t2(), p2.t3(), p2.t4(), p2.t5(), p2.t6(), p2.t7(), p2.t8());
    }

    public static <A> Codec<A> recursive(String name, Function<Codec<A>, Codec<A>> function) {
        return new RecursiveCodec(name, function);
    }

    public static <K, V> Codec<V> codecFromMap(Codec<K> keyCodec, BiMap<K, V> map) {
        return keyCodec.flatXmap(key -> {
            if (map.containsKey(key)) {
                return DataResult.success((Object)map.get(key));
            }
            return DataResult.error(() -> "Unknown key: " + String.valueOf(key));
        }, value -> {
            if (map.inverse().containsKey(value)) {
                return DataResult.success((Object)map.inverse().get(value));
            }
            return DataResult.error(() -> "Unknown value: " + String.valueOf(value));
        });
    }

    private static class RecursiveCodec<T>
    implements Codec<T> {
        private final String name;
        private final Supplier<Codec<T>> wrapped;

        private RecursiveCodec(String name, Function<Codec<T>, Codec<T>> wrapped) {
            this.name = name;
            this.wrapped = Suppliers.memoize(() -> (Codec)wrapped.apply(this));
        }

        public <S> DataResult<Pair<T, S>> decode(DynamicOps<S> ops, S input) {
            return this.wrapped.get().decode(ops, input);
        }

        public <S> DataResult<S> encode(T input, DynamicOps<S> ops, S prefix) {
            return this.wrapped.get().encode(input, ops, prefix);
        }

        public String toString() {
            return "RecursiveCodec[" + this.name + "]";
        }
    }
}

