/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.util;

import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.phys.Vec3;

public class JExplosionModifier {
    private final Boolean createFire;
    private final Explosion.BlockInteraction blockInteraction;
    private final SimpleParticleType particle;
    private final Vec3 particleVelocity;
    private final SoundEvent sound;
    private final SoundSource soundCategory;
    private final Function<RandomSource, Float> volumeGetter;
    private final Function<RandomSource, Float> pitchGetter;

    public void write(FriendlyByteBuf buf, RandomSource random) {
        this.write(this.createFire, buf, FriendlyByteBuf::writeBoolean);
        this.write(this.blockInteraction, buf, (b, dt) -> b.m_130130_(dt.ordinal()));
        this.write(this.particle, buf, (b, p) -> b.m_236858_((ResourceKey)BuiltInRegistries.f_257034_.m_7854_(p).orElseThrow()));
        this.write(this.particleVelocity, buf, (b, v) -> {
            b.writeDouble(v.f_82479_);
            b.writeDouble(v.f_82480_);
            b.writeDouble(v.f_82481_);
        });
        this.write(this.sound, buf, (b, s) -> b.m_236858_((ResourceKey)BuiltInRegistries.f_256894_.m_7854_((Object)this.sound).orElseThrow()));
        this.write(this.soundCategory, buf, (b, c) -> b.m_130130_(c.ordinal()));
        this.write(this.volumeGetter, buf, (b, v) -> b.writeFloat(((Float)v.apply(random)).floatValue()));
        this.write(this.pitchGetter, buf, (b, p) -> b.writeFloat(((Float)p.apply(random)).floatValue()));
    }

    private <T> void write(T t, FriendlyByteBuf buf, BiConsumer<FriendlyByteBuf, T> writer) {
        boolean nonNull = t != null;
        buf.writeBoolean(nonNull);
        if (nonNull) {
            writer.accept(buf, (FriendlyByteBuf)t);
        }
    }

    public static JExplosionModifier read(FriendlyByteBuf buf) {
        Builder builder = JExplosionModifier.builder().createFire(JExplosionModifier.read(buf, FriendlyByteBuf::readBoolean)).blockInteraction(JExplosionModifier.read(buf, b -> Explosion.BlockInteraction.values()[b.m_130242_()])).particle(JExplosionModifier.read(buf, b -> (SimpleParticleType)BuiltInRegistries.f_257034_.m_6246_(b.m_236801_(Registries.f_256890_)))).particleVelocity(JExplosionModifier.read(buf, b -> new Vec3(b.readDouble(), b.readDouble(), b.readDouble()))).sound(JExplosionModifier.read(buf, b -> (SoundEvent)BuiltInRegistries.f_256894_.m_6246_(b.m_236801_(Registries.f_256840_)))).soundCategory(JExplosionModifier.read(buf, b -> SoundSource.values()[b.m_130242_()]));
        if (buf.readBoolean()) {
            builder.volume(buf.readFloat());
        }
        if (buf.readBoolean()) {
            builder.pitch(buf.readFloat());
        }
        return builder.build();
    }

    private static <T> T read(FriendlyByteBuf buf, Function<FriendlyByteBuf, T> reader) {
        boolean nonNull = buf.readBoolean();
        return nonNull ? (T)reader.apply(buf) : null;
    }

    JExplosionModifier(Boolean createFire, Explosion.BlockInteraction blockInteraction, SimpleParticleType particle, Vec3 particleVelocity, SoundEvent sound, SoundSource soundCategory, Function<RandomSource, Float> volumeGetter, Function<RandomSource, Float> pitchGetter) {
        this.createFire = createFire;
        this.blockInteraction = blockInteraction;
        this.particle = particle;
        this.particleVelocity = particleVelocity;
        this.sound = sound;
        this.soundCategory = soundCategory;
        this.volumeGetter = volumeGetter;
        this.pitchGetter = pitchGetter;
    }

    public static Builder builder() {
        return new Builder();
    }

    public JExplosionModifier withCreateFire(Boolean createFire) {
        return this.createFire == createFire ? this : new JExplosionModifier(createFire, this.blockInteraction, this.particle, this.particleVelocity, this.sound, this.soundCategory, this.volumeGetter, this.pitchGetter);
    }

    public JExplosionModifier withBlockInteraction(Explosion.BlockInteraction blockInteraction) {
        return this.blockInteraction == blockInteraction ? this : new JExplosionModifier(this.createFire, blockInteraction, this.particle, this.particleVelocity, this.sound, this.soundCategory, this.volumeGetter, this.pitchGetter);
    }

    public JExplosionModifier withParticle(SimpleParticleType particle) {
        return this.particle == particle ? this : new JExplosionModifier(this.createFire, this.blockInteraction, particle, this.particleVelocity, this.sound, this.soundCategory, this.volumeGetter, this.pitchGetter);
    }

    public JExplosionModifier withParticleVelocity(Vec3 particleVelocity) {
        return this.particleVelocity == particleVelocity ? this : new JExplosionModifier(this.createFire, this.blockInteraction, this.particle, particleVelocity, this.sound, this.soundCategory, this.volumeGetter, this.pitchGetter);
    }

    public JExplosionModifier withSound(SoundEvent sound) {
        return this.sound == sound ? this : new JExplosionModifier(this.createFire, this.blockInteraction, this.particle, this.particleVelocity, sound, this.soundCategory, this.volumeGetter, this.pitchGetter);
    }

    public JExplosionModifier withSoundCategory(SoundSource soundCategory) {
        return this.soundCategory == soundCategory ? this : new JExplosionModifier(this.createFire, this.blockInteraction, this.particle, this.particleVelocity, this.sound, soundCategory, this.volumeGetter, this.pitchGetter);
    }

    public JExplosionModifier withVolumeGetter(Function<RandomSource, Float> volumeGetter) {
        return this.volumeGetter == volumeGetter ? this : new JExplosionModifier(this.createFire, this.blockInteraction, this.particle, this.particleVelocity, this.sound, this.soundCategory, volumeGetter, this.pitchGetter);
    }

    public JExplosionModifier withPitchGetter(Function<RandomSource, Float> pitchGetter) {
        return this.pitchGetter == pitchGetter ? this : new JExplosionModifier(this.createFire, this.blockInteraction, this.particle, this.particleVelocity, this.sound, this.soundCategory, this.volumeGetter, pitchGetter);
    }

    public Boolean getCreateFire() {
        return this.createFire;
    }

    public Explosion.BlockInteraction getBlockInteraction() {
        return this.blockInteraction;
    }

    public SimpleParticleType getParticle() {
        return this.particle;
    }

    public Vec3 getParticleVelocity() {
        return this.particleVelocity;
    }

    public SoundEvent getSound() {
        return this.sound;
    }

    public SoundSource getSoundCategory() {
        return this.soundCategory;
    }

    public Function<RandomSource, Float> getVolumeGetter() {
        return this.volumeGetter;
    }

    public Function<RandomSource, Float> getPitchGetter() {
        return this.pitchGetter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JExplosionModifier)) {
            return false;
        }
        JExplosionModifier other = (JExplosionModifier)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$createFire = this.getCreateFire();
        Boolean other$createFire = other.getCreateFire();
        if (this$createFire == null ? other$createFire != null : !((Object)this$createFire).equals(other$createFire)) {
            return false;
        }
        Explosion.BlockInteraction this$blockInteraction = this.getBlockInteraction();
        Explosion.BlockInteraction other$blockInteraction = other.getBlockInteraction();
        if (this$blockInteraction == null ? other$blockInteraction != null : !this$blockInteraction.equals(other$blockInteraction)) {
            return false;
        }
        SimpleParticleType this$particle = this.getParticle();
        SimpleParticleType other$particle = other.getParticle();
        if (this$particle == null ? other$particle != null : !this$particle.equals(other$particle)) {
            return false;
        }
        Vec3 this$particleVelocity = this.getParticleVelocity();
        Vec3 other$particleVelocity = other.getParticleVelocity();
        if (this$particleVelocity == null ? other$particleVelocity != null : !this$particleVelocity.equals(other$particleVelocity)) {
            return false;
        }
        SoundEvent this$sound = this.getSound();
        SoundEvent other$sound = other.getSound();
        if (this$sound == null ? other$sound != null : !this$sound.equals(other$sound)) {
            return false;
        }
        SoundSource this$soundCategory = this.getSoundCategory();
        SoundSource other$soundCategory = other.getSoundCategory();
        if (this$soundCategory == null ? other$soundCategory != null : !this$soundCategory.equals(other$soundCategory)) {
            return false;
        }
        Function<RandomSource, Float> this$volumeGetter = this.getVolumeGetter();
        Function<RandomSource, Float> other$volumeGetter = other.getVolumeGetter();
        if (this$volumeGetter == null ? other$volumeGetter != null : !this$volumeGetter.equals(other$volumeGetter)) {
            return false;
        }
        Function<RandomSource, Float> this$pitchGetter = this.getPitchGetter();
        Function<RandomSource, Float> other$pitchGetter = other.getPitchGetter();
        return !(this$pitchGetter == null ? other$pitchGetter != null : !this$pitchGetter.equals(other$pitchGetter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JExplosionModifier;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $createFire = this.getCreateFire();
        result = result * 59 + ($createFire == null ? 43 : ((Object)$createFire).hashCode());
        Explosion.BlockInteraction $blockInteraction = this.getBlockInteraction();
        result = result * 59 + ($blockInteraction == null ? 43 : $blockInteraction.hashCode());
        SimpleParticleType $particle = this.getParticle();
        result = result * 59 + ($particle == null ? 43 : $particle.hashCode());
        Vec3 $particleVelocity = this.getParticleVelocity();
        result = result * 59 + ($particleVelocity == null ? 43 : $particleVelocity.hashCode());
        SoundEvent $sound = this.getSound();
        result = result * 59 + ($sound == null ? 43 : $sound.hashCode());
        SoundSource $soundCategory = this.getSoundCategory();
        result = result * 59 + ($soundCategory == null ? 43 : $soundCategory.hashCode());
        Function<RandomSource, Float> $volumeGetter = this.getVolumeGetter();
        result = result * 59 + ($volumeGetter == null ? 43 : $volumeGetter.hashCode());
        Function<RandomSource, Float> $pitchGetter = this.getPitchGetter();
        result = result * 59 + ($pitchGetter == null ? 43 : $pitchGetter.hashCode());
        return result;
    }

    public String toString() {
        return "JExplosionModifier(createFire=" + this.getCreateFire() + ", blockInteraction=" + String.valueOf(this.getBlockInteraction()) + ", particle=" + String.valueOf(this.getParticle()) + ", particleVelocity=" + String.valueOf(this.getParticleVelocity()) + ", sound=" + String.valueOf(this.getSound()) + ", soundCategory=" + String.valueOf(this.getSoundCategory()) + ", volumeGetter=" + String.valueOf(this.getVolumeGetter()) + ", pitchGetter=" + String.valueOf(this.getPitchGetter()) + ")";
    }

    public static class Builder {
        private Boolean createFire;
        private Explosion.BlockInteraction blockInteraction;
        private SimpleParticleType particle;
        private Vec3 particleVelocity;
        private SoundEvent sound;
        private SoundSource soundCategory;
        private Function<RandomSource, Float> volumeGetter;
        private Function<RandomSource, Float> pitchGetter;

        public Builder volume(float volume) {
            this.volumeGetter(random -> Float.valueOf(volume));
            return this;
        }

        public Builder pitch(float pitch) {
            this.pitchGetter(random -> Float.valueOf(pitch));
            return this;
        }

        Builder() {
        }

        public Builder createFire(Boolean createFire) {
            this.createFire = createFire;
            return this;
        }

        public Builder blockInteraction(Explosion.BlockInteraction blockInteraction) {
            this.blockInteraction = blockInteraction;
            return this;
        }

        public Builder particle(SimpleParticleType particle) {
            this.particle = particle;
            return this;
        }

        public Builder particleVelocity(Vec3 particleVelocity) {
            this.particleVelocity = particleVelocity;
            return this;
        }

        public Builder sound(SoundEvent sound) {
            this.sound = sound;
            return this;
        }

        public Builder soundCategory(SoundSource soundCategory) {
            this.soundCategory = soundCategory;
            return this;
        }

        public Builder volumeGetter(Function<RandomSource, Float> volumeGetter) {
            this.volumeGetter = volumeGetter;
            return this;
        }

        public Builder pitchGetter(Function<RandomSource, Float> pitchGetter) {
            this.pitchGetter = pitchGetter;
            return this;
        }

        public JExplosionModifier build() {
            return new JExplosionModifier(this.createFire, this.blockInteraction, this.particle, this.particleVelocity, this.sound, this.soundCategory, this.volumeGetter, this.pitchGetter);
        }

        public String toString() {
            return "JExplosionModifier.Builder(createFire=" + this.createFire + ", blockInteraction=" + String.valueOf(this.blockInteraction) + ", particle=" + String.valueOf(this.particle) + ", particleVelocity=" + String.valueOf(this.particleVelocity) + ", sound=" + String.valueOf(this.sound) + ", soundCategory=" + String.valueOf(this.soundCategory) + ", volumeGetter=" + String.valueOf(this.volumeGetter) + ", pitchGetter=" + String.valueOf(this.pitchGetter) + ")";
        }
    }
}

