/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.util;

import com.google.common.base.MoreObjects;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntObjectPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.Attacks;
import net.arna.jcraft.api.attack.enums.MoveInputType;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.registry.JEntityTypeRegistry;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.api.registry.JTagRegistry;
import net.arna.jcraft.api.spec.JSpec;
import net.arna.jcraft.api.spec.JSpecHolder;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.api.stand.StandTypeUtil;
import net.arna.jcraft.common.config.JServerConfig;
import net.arna.jcraft.common.entity.damage.JDamageSources;
import net.arna.jcraft.common.entity.projectile.ItemTossProjectile;
import net.arna.jcraft.common.entity.projectile.JAttackEntity;
import net.arna.jcraft.common.entity.projectile.KnifeProjectile;
import net.arna.jcraft.common.entity.projectile.ScalpelProjectile;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.item.KnifeBundleItem;
import net.arna.jcraft.common.item.KnifeItem;
import net.arna.jcraft.common.item.ScalpelItem;
import net.arna.jcraft.common.network.s2c.JExplosionPacket;
import net.arna.jcraft.common.network.s2c.PlayerAnimPacket;
import net.arna.jcraft.common.network.s2c.ServerChannelFeedbackPacket;
import net.arna.jcraft.common.splatter.JSplatterManager;
import net.arna.jcraft.common.util.BlockInfo;
import net.arna.jcraft.common.util.IJExplosion;
import net.arna.jcraft.common.util.IJSplatterManagerHolder;
import net.arna.jcraft.common.util.JExplosionModifier;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.ThrownEgg;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.EggItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SnowballItem;
import net.minecraft.world.item.ThrowablePotionItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;

public final class JUtils {
    public static final float DEG_TO_RAD = (float)Math.PI / 180;
    public static final float RAD_TO_DEG = 57.29578f;
    private static final Map<EntityType<?>, Float> uniqueBloodMults = Map.ofEntries(Map.entry(EntityType.f_20501_, Float.valueOf(1.0f)), Map.entry(EntityType.f_20530_, Float.valueOf(1.0f)), Map.entry(EntityType.f_20502_, Float.valueOf(1.0f)), Map.entry(EntityType.f_20500_, Float.valueOf(0.5f)), Map.entry(EntityType.f_20531_, Float.valueOf(0.5f)), Map.entry(EntityType.f_20458_, Float.valueOf(0.1f)), Map.entry(EntityType.f_20492_, Float.valueOf(1.5f)), Map.entry(EntityType.f_20532_, Float.valueOf(1.5f)), Map.entry(EntityType.f_20460_, Float.valueOf(0.0f)), Map.entry(EntityType.f_20528_, Float.valueOf(0.0f)), Map.entry((EntityType)JEntityTypeRegistry.ROAD_ROLLER.get(), Float.valueOf(0.0f)), Map.entry((EntityType)JEntityTypeRegistry.SHEER_HEART_ATTACK.get(), Float.valueOf(0.0f)));
    public static int PLAYER_ANIMATION_DIST = 256;

    public static Vec3 randUnitVec(RandomSource random) {
        return new Vec3(random.m_188583_(), random.m_188583_(), random.m_188583_()).m_82541_();
    }

    public static Vec3 randUnitVec(Random random) {
        return new Vec3(random.nextGaussian(), random.nextGaussian(), random.nextGaussian()).m_82541_();
    }

    public static void addVelocity(Entity entity, Vec3 vel) {
        GravityChangerAPI.addWorldVelocity(entity, vel.f_82479_, vel.f_82480_, vel.f_82481_);
        JUtils.syncVelocityUpdate(entity);
    }

    public static void addVelocity(Entity entity, double x, double y, double z) {
        GravityChangerAPI.addWorldVelocity(entity, x, y, z);
        JUtils.syncVelocityUpdate(entity);
    }

    public static void setVelocity(Entity entity, Vec3 vel) {
        entity.m_20334_(vel.f_82479_, vel.f_82480_, vel.f_82481_);
        JUtils.syncVelocityUpdate(entity);
    }

    public static void setVelocity(Entity entity, double x, double y, double z) {
        entity.m_20334_(x, y, z);
        JUtils.syncVelocityUpdate(entity);
    }

    public static void syncVelocityUpdate(Entity entity) {
        entity.f_19864_ = true;
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(entity));
        }
    }

    public static boolean canAct(LivingEntity living) {
        MobEffectInstance stun = living.m_21124_((MobEffect)JStatusRegistry.DAZED.get());
        return stun == null || stun.m_19564_() == 2;
    }

    public static boolean canJump(LivingEntity living) {
        if (!JUtils.canAct(living)) {
            return false;
        }
        if (living.m_21023_((MobEffect)JStatusRegistry.KNOCKDOWN.get())) {
            return false;
        }
        StandEntity<?, ?> stand = JUtils.getStand(living);
        return stand == null || !stand.isRemoteAndControllable();
    }

    public static void displayHitbox(Level world, Vec3 min, Vec3 max) {
        JUtils.displayHitbox(world, new AABB(min, max));
    }

    public static void displayHitbox(Level world, AABB box) {
        JUtils.displayHitboxes(world, Set.of(box));
    }

    public static void displayHitboxes(Level world, Collection<AABB> boxes) {
        double maxZ;
        double maxY;
        double maxX;
        double minZ;
        double minY;
        double minX;
        FriendlyByteBuf buf;
        ServerLevel serverLevel;
        if (world instanceof ServerLevel) {
            serverLevel = (ServerLevel)world;
            buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.writeShort(1);
            buf.m_130130_(boxes.size());
            minX = Double.MAX_VALUE;
            minY = Double.MAX_VALUE;
            minZ = Double.MAX_VALUE;
            maxX = Double.MIN_VALUE;
            maxY = Double.MIN_VALUE;
            maxZ = Double.MIN_VALUE;
            for (AABB box : boxes) {
                if (box.f_82288_ < minX) {
                    minX = box.f_82288_;
                }
                if (box.f_82289_ < minY) {
                    minY = box.f_82289_;
                }
                if (box.f_82290_ < minZ) {
                    minZ = box.f_82290_;
                }
                if (box.f_82291_ < maxX) {
                    maxX = box.f_82291_;
                }
                if (box.f_82292_ < maxY) {
                    maxY = box.f_82292_;
                }
                if (box.f_82293_ < maxZ) {
                    maxZ = box.f_82293_;
                }
                buf.writeDouble(box.f_82288_);
                buf.writeDouble(box.f_82289_);
                buf.writeDouble(box.f_82290_);
                buf.writeDouble(box.f_82291_);
                buf.writeDouble(box.f_82292_);
                buf.writeDouble(box.f_82293_);
            }
        } else {
            throw new IllegalArgumentException("JUtils.displayHitboxes() must be called serverside!");
        }
        AABB entireBox = new AABB(minX, minY, minZ, maxX, maxY, maxZ).m_82400_(48.0);
        ServerChannelFeedbackPacket.send(serverLevel.m_8795_(p -> entireBox.m_82390_(p.m_20182_())), buf);
    }

    public static Set<LivingEntity> generateHitbox(Level world, Vec3 center, double hitboxSize, Set<Entity> except) {
        return JUtils.generateHitbox(world, center, hitboxSize, (Entity e) -> !except.contains(e));
    }

    public static Set<LivingEntity> generateHitbox(Level world, Vec3 center, double hitboxSize, Predicate<Entity> predicate) {
        double size = hitboxSize / 2.0;
        Vec3 v1 = center.m_82492_(size, size, size);
        Vec3 v2 = center.m_82520_(size, size, size);
        if (size > 0.0) {
            JUtils.displayHitbox(world, v1, v2);
        }
        List hit = world.m_6443_(LivingEntity.class, new AABB(v1, v2), EntitySelector.f_20406_.and(predicate));
        HashSet<LivingEntity> toReturn = new HashSet<LivingEntity>(hit);
        for (LivingEntity l : hit) {
            StandEntity stand;
            if (!(l instanceof StandEntity) || !(stand = (StandEntity)l).hasUser()) continue;
            toReturn.add(stand.getUserOrThrow());
        }
        return toReturn;
    }

    public static JSpec<?, ?> getSpec(LivingEntity livingEntity) {
        return JComponentPlatformUtils.getSpecData(livingEntity).getSpec();
    }

    public static void serverPlaySound(SoundEvent sound, ServerLevel serverWorld, Vec3 pos) {
        JUtils.serverPlaySound(sound, serverWorld, pos, 32.0);
    }

    public static void serverPlaySound(SoundEvent sound, ServerLevel serverWorld, Vec3 pos, double radius) {
        JUtils.around(serverWorld, pos, radius).forEach(serverPlayer -> serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(BuiltInRegistries.f_256894_.m_263177_((Object)sound), SoundSource.PLAYERS, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1.0f, 1.0f, 0L)));
    }

    public static BlockHitResult genericBlockRaycast(Level world, Entity entity, double range, ClipContext.Block shapeType, ClipContext.Fluid fluidHandling) {
        Vec3 eyePos = entity.m_20182_().m_82549_(GravityChangerAPI.getEyeOffset(entity));
        return world.m_45547_(new ClipContext(eyePos, eyePos.m_82549_(entity.m_20154_().m_82490_(range)), shapeType, fluidHandling, entity));
    }

    public static HitResult raycastAll(Entity entity, Vec3 start, Vec3 end, ClipContext.Fluid fluidHandling) {
        return JUtils.raycastAll(entity, start, end, fluidHandling, null);
    }

    public static HitResult raycastAll(Entity entity, Vec3 start, Vec3 end, ClipContext.Fluid fluidHandling, Predicate<Entity> entityPredicate) {
        EntityHitResult eHit;
        Level world = entity.m_9236_();
        double rangeSquared = start.m_82557_(end);
        Predicate<Entity> combined = EntitySelector.f_20406_.and(e -> !e.m_20365_(entity));
        if (entityPredicate != null) {
            combined = combined.and(entityPredicate);
        }
        boolean entityHit = (eHit = ProjectileUtil.m_37287_((Entity)entity, (Vec3)start, (Vec3)end, (AABB)entity.m_20191_().m_82400_(rangeSquared), combined, (double)rangeSquared)) != null && eHit.m_6662_() == HitResult.Type.ENTITY;
        BlockHitResult bHit = world.m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, fluidHandling, entity));
        Vec3 blockPos = bHit.m_82450_();
        if (entityHit) {
            Vec3 entityPos = eHit.m_82450_();
            if (blockPos.m_82557_(start) > entityPos.m_82557_(start)) {
                return eHit;
            }
            return bHit;
        }
        return bHit;
    }

    public static Direction getLookDirection(Entity entity) {
        Vec3 rotVec = entity.m_20154_();
        double x = rotVec.f_82479_;
        double y = rotVec.f_82480_;
        double z = rotVec.f_82481_;
        double absX = Math.abs(x);
        double absY = Math.abs(y);
        double absZ = Math.abs(z);
        Direction direction = Direction.DOWN;
        if (absX > absY && absX > absZ) {
            direction = x > 0.0 ? Direction.EAST : Direction.WEST;
        } else if (absY > absX && absY > absZ) {
            direction = y > 0.0 ? Direction.UP : Direction.DOWN;
        } else if (absZ > absX && absZ > absY) {
            direction = z > 0.0 ? Direction.SOUTH : Direction.NORTH;
        }
        return direction;
    }

    public static LivingEntity getUserIfStand(LivingEntity ent) {
        StandEntity stand;
        if (ent instanceof StandEntity && (stand = (StandEntity)ent).hasUser()) {
            return stand.getUser();
        }
        return ent;
    }

    public static Entity getUserIfStand(Entity ent) {
        StandEntity stand;
        if (ent instanceof StandEntity && (stand = (StandEntity)ent).hasUser()) {
            return stand.getUser();
        }
        return ent;
    }

    public static void projectileDamageLogic(Projectile proj, Level world, Entity ent, Vec3 kb, int stunT, int stunType, boolean overrideStun, float damage, int blockstun, CommonHitPropertyComponent.HitAnimation hitAnimation) {
        JUtils.projectileDamageLogic(proj, world, ent, kb, stunT, stunType, overrideStun, damage, blockstun, hitAnimation, false, false);
    }

    public static void projectileDamageLogic(Projectile proj, Level world, Entity ent, Vec3 kb, int stunT, int stunType, boolean overrideStun, float damage, int blockstun, CommonHitPropertyComponent.HitAnimation hitAnimation, boolean unblockable, boolean canBackstab) {
        if (world.f_46443_) {
            return;
        }
        Objects.requireNonNull(proj, "Attempted to run ProjectileDamageLogic with invalid projectile in world " + String.valueOf(world));
        Entity owner = proj.m_19749_();
        DamageSource source = owner == null ? JDamageSources.create(world, (ResourceKey<DamageType>)DamageTypes.f_268433_) : JDamageSources.create(world, (ResourceKey<DamageType>)DamageTypes.f_268534_, (Entity)proj, owner);
        if (ent instanceof LivingEntity) {
            LivingEntity living;
            LivingEntity target = living = (LivingEntity)ent;
            if (ent instanceof StandEntity) {
                StandEntity stand = (StandEntity)ent;
                target = stand.getUser();
            }
            Attacks.damageLogic(world, target, kb, stunT, stunType, overrideStun, damage, false, blockstun, source, owner, hitAnimation, canBackstab, unblockable);
        }
        if (ent instanceof EndCrystal) {
            EndCrystal endCrystal = (EndCrystal)ent;
            endCrystal.m_6469_(source, damage);
        }
    }

    public static float getDamageThroughArmor(float damage, float totalArmor, float toughnessAttribute) {
        if (totalArmor > 20.0f) {
            totalArmor = 20.0f;
        }
        if (toughnessAttribute > 12.0f) {
            toughnessAttribute = 12.0f;
        }
        return CombatRules.m_19272_((float)damage, (float)totalArmor, (float)toughnessAttribute);
    }

    public static boolean isBlocking(LivingEntity entity) {
        if (entity instanceof StandEntity) {
            StandEntity stand = (StandEntity)entity;
            return stand.blocking;
        }
        StandEntity<?, ?> stand = JUtils.getStand(entity);
        return stand != null && stand.blocking;
    }

    public static void stopTick(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.f_20884_ = livingEntity.f_20883_;
            livingEntity.f_20886_ = livingEntity.f_20885_;
            livingEntity.f_20920_ = livingEntity.f_20921_;
        }
        entity.f_19854_ = entity.m_20185_();
        entity.f_19855_ = entity.m_20186_();
        entity.f_19856_ = entity.m_20189_();
        entity.f_19790_ = entity.m_20185_();
        entity.f_19791_ = entity.m_20186_();
        entity.f_19792_ = entity.m_20189_();
        entity.f_19860_ = entity.m_146909_();
        entity.f_19859_ = entity.m_146908_();
        entity.f_19867_ = entity.f_19787_;
    }

    public static Vec3 deltaPos(@NonNull Entity ent) {
        if (ent == null) {
            throw new NullPointerException("ent is marked non-null but is null");
        }
        return new Vec3(ent.m_20185_() - ent.f_19854_, ent.m_20186_() - ent.f_19855_, ent.m_20189_() - ent.f_19856_);
    }

    public static List<BlockInfo> collectBlockInfo(Level world, BlockPos origin, int radius) {
        ArrayList<BlockInfo> infoList = new ArrayList<BlockInfo>();
        boolean[][] array = new boolean[radius * 2 + 1][radius * 2 + 1];
        int originX = origin.m_123341_();
        int originY = origin.m_123342_();
        int originZ = origin.m_123343_();
        for (int y = originY + radius; y >= originY - radius; --y) {
            for (int x = originX - radius; x <= originX + radius; ++x) {
                for (int z = originZ - radius; z <= originZ + radius; ++z) {
                    double distance = Math.sqrt(Math.pow(x - originX, 2.0) + Math.pow(y - originY, 2.0) + Math.pow(z - originZ, 2.0));
                    if (!(distance <= (double)radius)) continue;
                    double skipProbability = distance / (double)radius;
                    if (!(world.m_213780_().m_188500_() > skipProbability / 2.0)) continue;
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = world.m_8055_(pos);
                    int x0 = x - originX + radius;
                    int z0 = z - originZ + radius;
                    if (!state.m_60659_((BlockGetter)world, pos, Direction.UP, SupportType.RIGID) || array[x0][z0]) continue;
                    array[x0][z0] = true;
                    BlockInfo info = new BlockInfo(state, pos);
                    infoList.add(info);
                }
            }
        }
        return infoList;
    }

    public static void explode(Level world, double x, double y, double z, float power, JExplosionModifier modifier) {
        JUtils.explode(world, null, x, y, z, power, modifier);
    }

    public static void explode(Level world, @Nullable Entity entity, double x, double y, double z, float power, JExplosionModifier modifier) {
        if (modifier == null) {
            world.m_254849_(entity, x, y, z, power, Level.ExplosionInteraction.MOB);
            return;
        }
        Explosion explosion = new Explosion(world, entity, x, y, z, power, ((Boolean)MoreObjects.firstNonNull((Object)modifier.getCreateFire(), (Object)false)).booleanValue(), modifier.getBlockInteraction());
        ((IJExplosion)explosion).jcraft$setModifier(modifier);
        explosion.m_46061_();
        explosion.m_46075_(true);
        if (world.f_46443_) {
            return;
        }
        for (ServerPlayer player : JUtils.around((ServerLevel)world, new Vec3(x, y, z), 64.0)) {
            JExplosionPacket.send(player, x, y, z, power, explosion, modifier);
        }
    }

    public static <T> Function<T, IntObjectPair<T>> enumerate() {
        AtomicInteger index = new AtomicInteger();
        return t -> IntObjectPair.of((int)index.getAndIncrement(), (Object)t);
    }

    public static JSplatterManager getSplatterManager(Level world) {
        return ((IJSplatterManagerHolder)world).jcraft$getSplatterManager();
    }

    @Nullable
    public static StandEntity<?, ?> getStand(LivingEntity entity) {
        StandEntity stand;
        return entity == null ? null : (entity instanceof StandEntity ? (stand = (StandEntity)entity) : JComponentPlatformUtils.getStandComponent(entity).getStand());
    }

    public static boolean isAffectedByTimeStop(Entity entity) {
        return JComponentPlatformUtils.getTimeStopData(entity).map(data -> data.getTicks() > 0).orElse(false);
    }

    public static boolean canDamage(DamageSource damageSource, Entity ent) {
        ArmorStand armorStand;
        return ent != null && ent.m_6084_() && ent.m_6097_() && !ent.m_6673_(damageSource) && (!(ent instanceof ArmorStand) || !(armorStand = (ArmorStand)ent).m_31677_());
    }

    public static void cancelMoves(LivingEntity livingEntity) {
        StandEntity<?, ?> stand;
        Player player;
        JSpec<?, ?> spec;
        if (livingEntity instanceof Player && (spec = JUtils.getSpec((LivingEntity)(player = (Player)livingEntity))) != null) {
            spec.cancelMove();
        }
        if ((stand = JUtils.getStand(livingEntity)) != null) {
            stand.cancelMove();
        }
    }

    public static Vec2 rotationVectorToPolar(Vec3 rotationVector) {
        double x = rotationVector.f_82479_;
        double y = rotationVector.f_82480_;
        double z = rotationVector.f_82481_;
        double yaw = Math.atan2(x, z) * 57.29577951308232;
        double pitch = Math.atan2(rotationVector.m_165924_(), -y) * 57.29577951308232;
        return new Vec2(90.0f - (float)pitch, (float)(-yaw));
    }

    public static Mob mobCloneOf(Mob original) {
        EntityType entityType = original.m_6095_();
        Mob newMob = (Mob)entityType.m_20615_(original.m_9236_());
        if (newMob == null) {
            JCraft.LOGGER.error("Failed to create clone mob of type " + String.valueOf(entityType) + " in world " + String.valueOf(original.m_9236_()));
            return null;
        }
        newMob.m_6863_(original.m_6162_());
        if (original.m_8077_()) {
            newMob.m_6593_(original.m_7770_());
            newMob.m_20340_(original.m_20151_());
        }
        newMob.f_19797_ = original.f_19797_;
        newMob.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
        newMob.m_21409_(EquipmentSlot.OFFHAND, 0.0f);
        newMob.m_21409_(EquipmentSlot.HEAD, 0.0f);
        newMob.m_21409_(EquipmentSlot.CHEST, 0.0f);
        newMob.m_21409_(EquipmentSlot.LEGS, 0.0f);
        newMob.m_21409_(EquipmentSlot.FEET, 0.0f);
        return newMob;
    }

    public static float getBloodMult(LivingEntity entity) {
        EntityType type = entity.m_6095_();
        if (entity instanceof StandEntity) {
            return 0.0f;
        }
        if (type.m_204039_(EntityTypeTags.f_13121_)) {
            return 1.5f;
        }
        if (type.m_204039_(EntityTypeTags.f_13120_) || entity instanceof JAttackEntity) {
            return 0.0f;
        }
        if (type.m_204039_(EntityTypeTags.f_144293_)) {
            return 0.25f;
        }
        if (entity instanceof Animal) {
            return 0.5f;
        }
        if (uniqueBloodMults.containsKey(type)) {
            return uniqueBloodMults.get(type).floatValue();
        }
        if (!entity.m_21222_()) {
            return entity.m_21233_() / 20.0f;
        }
        return 0.0f;
    }

    public static boolean canHoldMove(ServerPlayer player, MoveInputType type) {
        JSpec<?, ?> spec;
        StandEntity<?, ?> stand = JUtils.getStand((LivingEntity)player);
        return stand != null && stand.canHoldMove(type) || (spec = JUtils.getSpec((LivingEntity)player)) != null && spec.canHoldMove(type) || type.isHoldable(stand != null && stand.isStandby());
    }

    public static void shoot(@NonNull Projectile projectile, @Nullable Entity shooter, float pitch, float yaw, float roll, float speed, float divergence) {
        if (projectile == null) {
            throw new NullPointerException("projectile is marked non-null but is null");
        }
        float f = -Mth.m_14031_((float)(yaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
        float g = -Mth.m_14031_((float)((pitch + roll) * ((float)Math.PI / 180)));
        float h = Mth.m_14089_((float)(yaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
        projectile.m_6686_((double)f, (double)g, (double)h, speed, divergence);
        if (shooter != null) {
            Vec3 vec3d = shooter.m_20184_();
            projectile.m_20256_(projectile.m_20184_().m_82520_(vec3d.f_82479_, shooter.m_20096_() ? 0.0 : vec3d.f_82480_, vec3d.f_82481_));
        }
    }

    public static boolean playAnimIfUnoccupied(LivingEntity living, String animation) {
        JSpec<?, ?> spec = JComponentPlatformUtils.getSpecData(living).getSpec();
        if (spec != null && spec.moveStun > 0) {
            return false;
        }
        JUtils.playAnim(living, animation);
        return true;
    }

    public static void playAnim(LivingEntity living, String animation) {
        if (living instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)living;
            JUtils.around(player.m_284548_(), player.m_20182_(), PLAYER_ANIMATION_DIST).forEach(p -> PlayerAnimPacket.send((Player)player, p, animation));
        } else if (living instanceof JSpecHolder) {
            JSpecHolder specHolder = (JSpecHolder)living;
            specHolder.setAnimation(animation, 1.0f);
        }
    }

    public static Collection<ServerPlayer> around(ServerLevel world, Vec3 pos, double radius) {
        double radiusSq = radius * radius;
        ArrayList<ServerPlayer> list = new ArrayList<ServerPlayer>();
        for (ServerPlayer p : world.m_6907_()) {
            if (!(p.m_20238_(pos) <= radiusSq)) continue;
            list.add(p);
        }
        return list;
    }

    public static Collection<ServerPlayer> all(MinecraftServer server) {
        Objects.requireNonNull(server, "The server cannot be null");
        if (server.m_6846_() != null) {
            return Collections.unmodifiableCollection(server.m_6846_().m_11314_());
        }
        return Collections.emptyList();
    }

    @NonNull
    public static Collection<ServerPlayer> tracking(@NonNull Entity entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        ChunkSource chunkSource = entity.m_9236_().m_7726_();
        if (chunkSource instanceof ServerChunkCache) {
            ServerChunkCache serverChunkCache = (ServerChunkCache)chunkSource;
            ChunkMap storage = serverChunkCache.f_8325_;
            ChunkMap.TrackedEntity tracker = (ChunkMap.TrackedEntity)storage.f_140150_.get(entity.m_19879_());
            if (tracker != null) {
                return tracker.f_140475_.stream().map(ServerPlayerConnection::m_142253_).collect(Collectors.toUnmodifiableSet());
            }
            return Collections.emptySet();
        }
        throw new IllegalArgumentException("Only supported on server worlds!");
    }

    public static Vector2f getLookPY(Vec3 origin, Vec3 target) {
        double d = target.f_82479_ - origin.f_82479_;
        double e = target.f_82480_ - origin.f_82480_;
        double f = target.f_82481_ - origin.f_82481_;
        double g = Math.sqrt(d * d + f * f);
        float yaw = Mth.m_14177_((float)((float)(Mth.m_14136_((double)(-f), (double)(-d)) * 57.2957763671875) - 90.0f));
        float pitch = Mth.m_14177_((float)((float)(Mth.m_14136_((double)(-e), (double)(-g)) * 57.2957763671875)));
        return new Vector2f(pitch, yaw);
    }

    public static Vec3 getLookVector(Vec3 origin, Vec3 target) {
        Vector2f pitchYaw = JUtils.getLookPY(origin, target);
        float pitch = pitchYaw.x;
        float yaw = pitchYaw.y;
        return new Vec3((double)(-Mth.m_14031_((float)(yaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)))), (double)(-Mth.m_14031_((float)(pitch * ((float)Math.PI / 180)))), (double)(Mth.m_14089_((float)(yaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)))));
    }

    public static boolean isFerrous(@Nullable Entity entity) {
        if (entity == null) {
            return false;
        }
        if (entity.m_6095_().m_204039_(JTagRegistry.FERROUS_ENTITIES)) {
            return true;
        }
        String stringName = entity.m_7755_().toString().toLowerCase(Locale.ROOT);
        return stringName.contains("iron") || stringName.contains("ferro");
    }

    public static boolean shouldRenderStandsFor(Player player) {
        if (JServerConfig.STAND_USER_SIGHT.getValue()) {
            StandType standType = JComponentPlatformUtils.getStandComponent((LivingEntity)player).getType();
            return !StandTypeUtil.isNone(standType);
        }
        return true;
    }

    public static void tossItem(LivingEntity shooter, Level level, ItemStack itemStack, float velocity, boolean decrement) {
        if (level.m_5776_() || itemStack.m_41619_()) {
            return;
        }
        Item item = itemStack.m_41720_();
        if (item instanceof ArrowItem) {
            ArrowItem arrow = (ArrowItem)item;
            AbstractArrow arrowEntity = arrow.m_6394_(level, itemStack, shooter);
            arrowEntity.m_37251_((Entity)shooter, shooter.m_146909_(), shooter.m_146908_(), 0.0f, velocity, 1.0f);
            level.m_7967_((Entity)arrowEntity);
        } else if (itemStack.m_41720_() instanceof SnowballItem) {
            Snowball snowballEntity = new Snowball(level, shooter);
            snowballEntity.m_37446_(itemStack);
            snowballEntity.m_37251_((Entity)shooter, shooter.m_146909_(), shooter.m_146908_(), 0.0f, velocity, 1.0f);
            level.m_7967_((Entity)snowballEntity);
        } else if (itemStack.m_41720_() instanceof TridentItem) {
            ThrownTrident thrownTrident = new ThrownTrident(level, shooter, itemStack);
            thrownTrident.m_37251_((Entity)shooter, shooter.m_146909_(), shooter.m_146908_(), 0.0f, velocity, 1.0f);
            level.m_7967_((Entity)thrownTrident);
        } else if (itemStack.m_41720_() instanceof ThrowablePotionItem) {
            ThrownPotion thrownPotion = new ThrownPotion(level, shooter);
            thrownPotion.m_37446_(itemStack);
            thrownPotion.m_37251_((Entity)shooter, shooter.m_146909_(), shooter.m_146908_(), 0.0f, velocity, 1.0f);
            level.m_7967_((Entity)thrownPotion);
        } else if (itemStack.m_41720_() instanceof EggItem) {
            ThrownEgg thrownEgg = new ThrownEgg(level, shooter);
            thrownEgg.m_37446_(itemStack);
            thrownEgg.m_37251_((Entity)shooter, shooter.m_146909_(), shooter.m_146908_(), 0.0f, velocity, 1.0f);
            level.m_7967_((Entity)thrownEgg);
        } else if (itemStack.m_41720_() instanceof ScalpelItem) {
            ScalpelProjectile scalpelProjectile = new ScalpelProjectile(level, shooter);
            scalpelProjectile.m_37251_((Entity)shooter, shooter.m_146909_(), shooter.m_146908_(), 0.0f, velocity, 1.0f);
            level.m_7967_((Entity)scalpelProjectile);
        } else if (itemStack.m_41720_() instanceof KnifeBundleItem) {
            for (int i = 0; i < 9; ++i) {
                KnifeProjectile knife = new KnifeProjectile(level, shooter);
                knife.m_146884_(knife.m_20182_().m_82520_(level.f_46441_.m_216328_(0.0, 0.5), level.f_46441_.m_216328_(0.0, 0.5), level.f_46441_.m_216328_(0.0, 0.5)));
                knife.m_37251_((Entity)shooter, shooter.m_146909_(), shooter.m_146908_(), 0.0f, velocity, 5.0f);
                level.m_7967_((Entity)knife);
            }
        } else if (itemStack.m_41720_() instanceof KnifeItem) {
            KnifeProjectile knifeProjectile = new KnifeProjectile(level, shooter);
            knifeProjectile.m_37251_((Entity)shooter, shooter.m_146909_(), shooter.m_146908_(), 0.0f, velocity, 1.0f);
            level.m_7967_((Entity)knifeProjectile);
        } else {
            ItemTossProjectile projectile = new ItemTossProjectile(shooter, level, itemStack);
            projectile.m_37251_((Entity)shooter, shooter.m_146909_(), shooter.m_146908_(), 0.0f, velocity, 1.0f);
            level.m_7967_((Entity)projectile);
            shooter.m_216990_((SoundEvent)JSoundRegistry.TOSS.get());
        }
        if (decrement) {
            itemStack.m_41774_(1);
        }
    }

    public static void tossItem(Player player) {
        JUtils.tossItem((LivingEntity)player, player.m_9236_(), player.m_21120_(InteractionHand.MAIN_HAND), 1.0f, !player.m_150110_().f_35937_);
    }

    public static double nullSafeDistanceSqr(@Nullable LivingEntity a, @Nullable LivingEntity b) {
        if (a == null || b == null) {
            return Double.POSITIVE_INFINITY;
        }
        return a.m_20280_((Entity)b);
    }

    public static double min(double ... arr) {
        double min = Double.POSITIVE_INFINITY;
        for (double v : arr) {
            if (!(v < min)) continue;
            min = v;
        }
        return min;
    }

    @SafeVarargs
    @NonNull
    public static <T> T chooseRandom(@NonNull RandomSource rng, T ... items) {
        if (rng == null) {
            throw new NullPointerException("rng is marked non-null but is null");
        }
        if (items == null || items.length == 0) {
            throw new IllegalArgumentException("At least one item must be provided.");
        }
        return items[rng.m_188503_(items.length)];
    }
}

