/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.forge;

import dev.architectury.event.events.common.TickEvent;
import dev.architectury.platform.forge.EventBuses;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.common.events.EntityTickEvent;
import net.arna.jcraft.forge.JNetworkingForge;
import net.arna.jcraft.forge.capability.impl.entity.GrabCapability;
import net.arna.jcraft.forge.capability.impl.entity.GravityCapability;
import net.arna.jcraft.forge.capability.impl.living.BombTrackerCapability;
import net.arna.jcraft.forge.capability.impl.living.CooldownsCapability;
import net.arna.jcraft.forge.capability.impl.living.GravityShiftCapability;
import net.arna.jcraft.forge.capability.impl.living.HitPropertyCapability;
import net.arna.jcraft.forge.capability.impl.living.MiscCapability;
import net.arna.jcraft.forge.capability.impl.living.VampireCapability;
import net.arna.jcraft.forge.capability.impl.world.ShockwaveHandlerCapability;
import net.arna.jcraft.forge.events.ClientSetupEvents;
import net.arna.jcraft.forge.loot.JForgeLootModifiers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.Bindings;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="jcraft")
public final class JCraftForge {
    public JCraftForge() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = (IEventBus)Bindings.getForgeBus().get();
        EventBuses.registerModEventBus((String)"jcraft", (IEventBus)modBus);
        JCraft.init();
        modBus.addListener(this::onInitializeCommon);
        modBus.addListener(ClientSetupEvents::onInitializeClient);
        JForgeLootModifiers.register(modBus);
        JNetworkingForge.initServer();
        EntityTickEvent.ENTITY_PRE.register(JCraftForge::tickEntityCaps);
        TickEvent.ServerLevelTick.SERVER_LEVEL_POST.register(JCraftForge::tickWorldCaps);
    }

    @SubscribeEvent
    public void onInitializeCommon(FMLCommonSetupEvent event) {
        JCraft.postInit();
    }

    public static void tickWorldCaps(Level world) {
        ShockwaveHandlerCapability.getCapability(world).tick();
    }

    public static void tickEntityCaps(Entity entity) {
        GrabCapability.getCapability(entity).tick();
        GravityCapability.getCapability(entity).tick();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            GravityShiftCapability.getCapability(living).tick();
            BombTrackerCapability.getCapability(living).tick();
            CooldownsCapability.getCapability(living).tick();
            HitPropertyCapability.getCapability(living).tick();
            MiscCapability.getCapability(living).tick();
            VampireCapability.getCapability(living).tick();
        }
    }
}

