/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.forge.capability.api;

import lombok.NonNull;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import org.jetbrains.annotations.Nullable;

public class JCapabilityProvider<C extends INBTSerializable<CompoundTag>>
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    private final C instance;
    private final LazyOptional<C> capOptional;
    private final Capability<C> capability;

    public JCapabilityProvider(Capability<C> capability, NonNullSupplier<C> capInstance) {
        this.capability = capability;
        this.instance = (INBTSerializable)capInstance.get();
        this.capOptional = LazyOptional.of(() -> this.instance);
    }

    @NonNull
    public <T> LazyOptional<T> getCapability(@NonNull Capability<T> cap, @Nullable Direction side) {
        if (cap == null) {
            throw new NullPointerException("cap is marked non-null but is null");
        }
        return this.capability.orEmpty(cap, this.capOptional);
    }

    public CompoundTag serializeNBT() {
        return (CompoundTag)this.instance.serializeNBT();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.instance.deserializeNBT((Tag)nbt);
    }
}

