/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.forge.capability.impl.entity;

import dev.architectury.networking.NetworkManager;
import java.util.Optional;
import net.arna.jcraft.common.component.impl.entity.CommonGravityComponentImpl;
import net.arna.jcraft.forge.JNetworkingForge;
import net.arna.jcraft.forge.capability.api.JCapability;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class GravityCapability
extends CommonGravityComponentImpl
implements JCapability {
    public static ResourceLocation G_S2C = new ResourceLocation("jcraft", "g_s2c");
    public static ResourceLocation G_C2S = new ResourceLocation("jcraft", "g_c2s");
    public static Capability<GravityCapability> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<GravityCapability>(){});

    public GravityCapability(Entity entity) {
        super(entity);
    }

    public static void syncEntityCapability(PlayerEvent.StartTracking event) {
        LivingEntity livingEntity;
        Entity entity = event.getTarget();
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_9236_() instanceof ServerLevel) {
            GravityCapability.syncEntityCapability((Entity)livingEntity);
        }
        if (event.getEntity() instanceof Player && event.getEntity().m_9236_() instanceof ServerLevel) {
            GravityCapability.syncEntityCapability((Entity)event.getEntity());
        }
    }

    private static void syncEntityCapability(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            JNetworkingForge.sendPackets((Entity)living, G_S2C, G_C2S, GravityCapability.getCapability((Entity)living));
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        super.writeToNbt(tag);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        super.readFromNbt(tag);
    }

    public static Optional<GravityCapability> getCapabilityOptional(Entity user) {
        return user.getCapability(CAPABILITY).resolve();
    }

    public static GravityCapability getCapability(Entity user) {
        return (GravityCapability)user.getCapability(CAPABILITY).orElse((Object)new GravityCapability(user));
    }

    public static void initServer() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)G_C2S, (buf, context) -> {
            int id = buf.readInt();
            CompoundTag nbt = buf.m_130260_();
            Entity patt0$temp = context.getPlayer().m_9236_().m_6815_(id);
            if (patt0$temp instanceof Player) {
                Player player = (Player)patt0$temp;
                GravityCapability.getCapabilityOptional((Entity)player).ifPresent(c -> c.deserializeNBT(nbt));
            }
        });
    }
}

