/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.forge.capability.impl.entity;

import dev.architectury.networking.NetworkManager;
import java.util.Optional;
import net.arna.jcraft.common.component.impl.entity.CommonTimeStopComponentImpl;
import net.arna.jcraft.forge.JNetworkingForge;
import net.arna.jcraft.forge.capability.api.JCapability;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class TimeStopCapability
extends CommonTimeStopComponentImpl
implements JCapability {
    public static ResourceLocation TIME_S2C = new ResourceLocation("jcraft", "time_s2c");
    public static ResourceLocation TIME_C2S = new ResourceLocation("jcraft", "time_c2s");
    public static Capability<TimeStopCapability> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<TimeStopCapability>(){});

    public TimeStopCapability(Entity entity) {
        super(entity);
    }

    @Override
    public void sync(Entity entity) {
        if (entity != null) {
            TimeStopCapability.syncEntityCapability(entity);
        }
    }

    private static void syncEntityCapability(Entity entity) {
        if (entity != null) {
            JNetworkingForge.sendPackets(entity, TIME_S2C, TIME_C2S, TimeStopCapability.getCapability(entity));
        }
    }

    public static void syncEntityCapability(PlayerEvent.StartTracking event) {
        LivingEntity livingEntity;
        Entity entity = event.getTarget();
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_9236_() instanceof ServerLevel) {
            TimeStopCapability.syncEntityCapability((Entity)livingEntity);
        }
        if (event.getEntity() instanceof Player && event.getEntity().m_9236_() instanceof ServerLevel) {
            TimeStopCapability.syncEntityCapability((Entity)event.getEntity());
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        super.writeToNbt(tag);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        super.readFromNbt(tag);
    }

    public static Optional<TimeStopCapability> getCapabilityOptional(Entity entity) {
        return entity.getCapability(CAPABILITY).resolve();
    }

    public static TimeStopCapability getCapability(Entity entity) {
        return (TimeStopCapability)entity.getCapability(CAPABILITY).orElse((Object)new TimeStopCapability(entity));
    }

    public static void initServer() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)TIME_C2S, (buf, context) -> {
            int id = buf.readInt();
            CompoundTag nbt = buf.m_130260_();
            Entity entity = context.getPlayer().m_9236_().m_6815_(id);
            if (entity != null) {
                TimeStopCapability.getCapabilityOptional(entity).ifPresent(c -> c.deserializeNBT(nbt));
            }
        });
    }
}

