/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.forge.capability.impl.living;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import net.arna.jcraft.common.component.impl.living.CommonBombTrackerComponentImpl;
import net.arna.jcraft.forge.capability.api.JCapability;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;

public class BombTrackerCapability
extends CommonBombTrackerComponentImpl
implements JCapability {
    public static ResourceLocation BOMB_S2C = new ResourceLocation("jcraft", "bomb_s2c");
    public static Capability<BombTrackerCapability> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<BombTrackerCapability>(){});

    public BombTrackerCapability(LivingEntity entity) {
        super((Entity)entity);
    }

    @Override
    public void sync(Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            this.writeSyncPacket(buf, player);
            NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)BOMB_S2C, (FriendlyByteBuf)buf);
        }
        super.sync(entity);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        super.writeToNbt(tag);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        super.readFromNbt(tag);
    }

    public static LazyOptional<BombTrackerCapability> getCapabilityOptional(Entity entity) {
        return entity.getCapability(CAPABILITY);
    }

    public static BombTrackerCapability getCapability(LivingEntity entity) {
        return (BombTrackerCapability)entity.getCapability(CAPABILITY).orElse((Object)new BombTrackerCapability(entity));
    }
}

