/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.forge.capability.impl.living;

import dev.architectury.networking.NetworkManager;
import net.arna.jcraft.common.component.impl.living.CommonCooldownsComponentImpl;
import net.arna.jcraft.forge.JNetworkingForge;
import net.arna.jcraft.forge.capability.api.JCapability;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class CooldownsCapability
extends CommonCooldownsComponentImpl
implements JCapability {
    public static ResourceLocation CD_S2C = new ResourceLocation("jcraft", "cd_s2c");
    public static ResourceLocation CD_C2S = new ResourceLocation("jcraft", "cd_c2s");
    public static Capability<CooldownsCapability> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<CooldownsCapability>(){});

    public CooldownsCapability(LivingEntity entity) {
        super((Entity)entity);
    }

    @Override
    public void sync(Entity entity) {
        super.sync(entity);
        if (entity != null) {
            CooldownsCapability.syncEntityCapability(entity);
        }
    }

    private static void syncEntityCapability(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            JNetworkingForge.sendPackets((Entity)living, CD_S2C, CD_C2S, CooldownsCapability.getCapability(living));
        }
    }

    public static void syncEntityCapability(PlayerEvent.StartTracking event) {
        LivingEntity livingEntity;
        Entity entity = event.getTarget();
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_9236_() instanceof ServerLevel) {
            CooldownsCapability.syncEntityCapability((Entity)livingEntity);
        }
        if (event.getEntity() instanceof Player && event.getEntity().m_9236_() instanceof ServerLevel) {
            CooldownsCapability.syncEntityCapability((Entity)event.getEntity());
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        super.writeToNbt(tag);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        super.readFromNbt(tag);
    }

    public static LazyOptional<CooldownsCapability> getCapabilityOptional(Entity entity) {
        return entity.getCapability(CAPABILITY);
    }

    public static CooldownsCapability getCapability(LivingEntity entity) {
        return (CooldownsCapability)entity.getCapability(CAPABILITY).orElse((Object)new CooldownsCapability(entity));
    }

    public static void initServer() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)CD_C2S, (buf, context) -> {
            int id = buf.readInt();
            CompoundTag nbt = buf.m_130260_();
            Entity patt0$temp = context.getPlayer().m_9236_().m_6815_(id);
            if (patt0$temp instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)patt0$temp;
                CooldownsCapability.getCapabilityOptional((Entity)livingEntity).ifPresent(c -> c.deserializeNBT(nbt));
            }
        });
    }
}

