/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.forge.capability.impl.living;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import lombok.NonNull;
import net.arna.jcraft.common.component.impl.CommonGravityShiftComponentImpl;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.forge.capability.api.JCapability;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;

public class GravityShiftCapability
extends CommonGravityShiftComponentImpl
implements JCapability {
    public static ResourceLocation GS_S2C = new ResourceLocation("jcraft", "gs_s2c");
    public static Capability<GravityShiftCapability> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<GravityShiftCapability>(){});
    private static final int RANGE = (int)Math.sqrt(10000.0);

    public GravityShiftCapability(LivingEntity user) {
        super(user);
    }

    @Override
    public void sync(Entity entity) {
        super.sync(entity);
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.writeInt(entity.m_19879_());
            CompoundTag nbt = new CompoundTag();
            this.writeToNbt(nbt);
            buf.m_130079_(nbt);
            NetworkManager.sendToPlayers(JUtils.around(serverWorld, entity.m_20182_(), RANGE), (ResourceLocation)GS_S2C, (FriendlyByteBuf)buf);
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        super.writeToNbt(tag);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        super.readFromNbt(tag);
    }

    @NonNull
    public static LazyOptional<GravityShiftCapability> getCapabilityOptional(LivingEntity user) {
        return user.getCapability(CAPABILITY);
    }

    public static GravityShiftCapability getCapability(LivingEntity user) {
        return (GravityShiftCapability)user.getCapability(CAPABILITY).orElse((Object)new GravityShiftCapability(user));
    }
}

