/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.forge.capability.impl.living;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.Set;
import java.util.stream.Collectors;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.common.component.impl.living.CommonHitPropertyComponentImpl;
import net.arna.jcraft.forge.capability.api.JCapability;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;

public class HitPropertyCapability
extends CommonHitPropertyComponentImpl
implements JCapability {
    public static ResourceLocation HIT_S2C = new ResourceLocation("jcraft", "hit_s2c");
    public static Capability<HitPropertyCapability> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<HitPropertyCapability>(){});

    public HitPropertyCapability(LivingEntity living) {
        super((Entity)living);
    }

    @Override
    public void setHitAnimation(CommonHitPropertyComponent.HitAnimation hitAnimation, int duration) {
        super.setHitAnimation(hitAnimation, duration);
        Entity entity = this.entity;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            Level level = this.entity.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)level;
                FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                buf.m_130130_(livingEntity.m_19879_());
                this.writeSyncPacket(buf, null);
                Set recipients = serverWorld.m_6907_().stream().filter(this::shouldSyncWith).collect(Collectors.toUnmodifiableSet());
                NetworkManager.sendToPlayers(recipients, (ResourceLocation)HIT_S2C, (FriendlyByteBuf)buf);
            }
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        super.writeToNbt(tag);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        super.readFromNbt(tag);
    }

    public static LazyOptional<HitPropertyCapability> getCapabilityOptional(Entity entity) {
        return entity.getCapability(CAPABILITY);
    }

    public static HitPropertyCapability getCapability(LivingEntity entity) {
        return (HitPropertyCapability)entity.getCapability(CAPABILITY).orElse((Object)new HitPropertyCapability(entity));
    }
}

