/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.forge.capability.impl.living;

import dev.architectury.networking.NetworkManager;
import net.arna.jcraft.common.component.impl.living.CommonMiscComponentImpl;
import net.arna.jcraft.forge.JNetworkingForge;
import net.arna.jcraft.forge.capability.api.JCapability;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class MiscCapability
extends CommonMiscComponentImpl
implements JCapability {
    public static ResourceLocation MISC_S2C = new ResourceLocation("jcraft", "misc_s2c");
    public static ResourceLocation MISC_C2S = new ResourceLocation("jcraft", "misc_c2s");
    public static Capability<MiscCapability> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<MiscCapability>(){});

    public MiscCapability(LivingEntity living) {
        super((Entity)living);
    }

    @Override
    public void sync(Entity entity) {
        super.sync(entity);
        if (entity != null) {
            MiscCapability.syncEntityCapability(entity);
        }
    }

    private static void syncEntityCapability(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            JNetworkingForge.sendPackets((Entity)living, MISC_S2C, MISC_C2S, MiscCapability.getCapability(living));
        }
    }

    public static void syncEntityCapability(PlayerEvent.StartTracking event) {
        LivingEntity livingEntity;
        Entity entity = event.getTarget();
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_9236_() instanceof ServerLevel) {
            MiscCapability.syncEntityCapability((Entity)livingEntity);
        }
        if (event.getEntity() instanceof Player && event.getEntity().m_9236_() instanceof ServerLevel) {
            MiscCapability.syncEntityCapability((Entity)event.getEntity());
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        super.writeToNbt(tag);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        super.readFromNbt(tag);
    }

    public static LazyOptional<MiscCapability> getCapabilityOptional(Entity entity) {
        return entity.getCapability(CAPABILITY);
    }

    public static MiscCapability getCapability(LivingEntity entity) {
        return (MiscCapability)entity.getCapability(CAPABILITY).orElse((Object)new MiscCapability(entity));
    }

    public static void initServer() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)MISC_C2S, (buf, context) -> {
            int id = buf.readInt();
            CompoundTag nbt = buf.m_130260_();
            Entity patt0$temp = context.getPlayer().m_9236_().m_6815_(id);
            if (patt0$temp instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)patt0$temp;
                MiscCapability.getCapabilityOptional((Entity)livingEntity).ifPresent(c -> c.deserializeNBT(nbt));
            }
        });
    }
}

