/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.forge.capability.impl.living;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.common.component.impl.living.CommonStandComponentImpl;
import net.arna.jcraft.forge.capability.api.JCapability;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class StandCapability
extends CommonStandComponentImpl
implements JCapability {
    public static ResourceLocation STAND_S2C = new ResourceLocation("jcraft", "stand_s2c");
    public static Capability<StandCapability> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<StandCapability>(){});

    public StandCapability(LivingEntity living) {
        super((Entity)living);
    }

    @Override
    public void sync(Entity entity) {
        super.sync(entity);
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            StandCapability.syncEntityCapability((Player)serverPlayer, (LivingEntity)serverPlayer);
        }
    }

    private static void syncEntityCapability(Player recipient, LivingEntity standUser) {
        if (recipient instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)recipient;
            StandCapability standCapability = StandCapability.getCapability(standUser);
            StandType standType = standCapability.getType();
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.writeInt(standUser.m_19879_());
            buf.writeBoolean(standType == null);
            if (standType != null) {
                buf.m_130085_(standType.getId());
            }
            buf.writeInt(standCapability.getSkin());
            standCapability.writeSyncPacket(buf, serverPlayer);
            NetworkManager.sendToPlayer((ServerPlayer)serverPlayer, (ResourceLocation)STAND_S2C, (FriendlyByteBuf)buf);
        }
    }

    public static void syncEntityCapability(PlayerEvent.StartTracking event) {
        LivingEntity livingEntity;
        Entity entity = event.getTarget();
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_9236_() == event.getEntity().m_9236_()) {
            StandCapability.syncEntityCapability(event.getEntity(), livingEntity);
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        super.writeToNbt(tag);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        super.readFromNbt(tag);
    }

    public static LazyOptional<StandCapability> getCapabilityOptional(Entity entity) {
        return entity.getCapability(CAPABILITY);
    }

    public static StandCapability getCapability(LivingEntity entity) {
        return (StandCapability)entity.getCapability(CAPABILITY).orElse((Object)new StandCapability(entity));
    }
}

