/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.forge.capability.impl.living;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import net.arna.jcraft.common.component.impl.CommonVampireComponentImpl;
import net.arna.jcraft.forge.capability.api.JCapability;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;

public class VampireCapability
extends CommonVampireComponentImpl
implements JCapability {
    public static ResourceLocation VAMP_S2C = new ResourceLocation("jcraft", "vamp_s2c");
    public static Capability<VampireCapability> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<VampireCapability>(){});

    public VampireCapability(LivingEntity living) {
        super(living);
    }

    @Override
    public void sync(Entity entity) {
        super.sync(entity);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            this.writeSyncPacket(buf, player);
            NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)VAMP_S2C, (FriendlyByteBuf)buf);
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        super.writeToNbt(tag);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        super.readFromNbt(tag);
    }

    public static LazyOptional<VampireCapability> getCapabilityOptional(Entity entity) {
        return entity.getCapability(CAPABILITY);
    }

    public static VampireCapability getCapability(LivingEntity entity) {
        return (VampireCapability)entity.getCapability(CAPABILITY).orElse((Object)new VampireCapability(entity));
    }
}

