/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.forge.capability.impl.player;

import dev.architectury.networking.NetworkManager;
import lombok.NonNull;
import net.arna.jcraft.common.component.impl.player.CommonPhComponentImpl;
import net.arna.jcraft.forge.JNetworkingForge;
import net.arna.jcraft.forge.capability.api.JCapability;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class PhCapability
extends CommonPhComponentImpl
implements JCapability {
    public static ResourceLocation PH_S2C = new ResourceLocation("jcraft", "ph_s2c");
    public static ResourceLocation PH_C2S = new ResourceLocation("jcraft", "ph_c2s");
    public static Capability<PhCapability> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PhCapability>(){});

    public PhCapability(Player player) {
        super(player);
    }

    @Override
    public void sync(Entity entity) {
        super.sync(entity);
        if (entity != null) {
            PhCapability.syncEntityCapability(entity);
        }
    }

    public static void syncEntityCapability(Entity entity) {
        if (entity instanceof Player) {
            Player living = (Player)entity;
            JNetworkingForge.sendPackets((Entity)living, PH_S2C, PH_C2S, PhCapability.getCapability(living));
        }
    }

    public static void syncEntityCapability(PlayerEvent.StartTracking event) {
        if (event.getEntity() instanceof Player && event.getEntity().m_9236_() instanceof ServerLevel) {
            PhCapability.syncEntityCapability((Entity)event.getEntity());
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        super.writeToNbt(tag);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        super.readFromNbt(tag);
    }

    @NonNull
    public static LazyOptional<PhCapability> getCapabilityOptional(Player player) {
        return player.getCapability(CAPABILITY);
    }

    public static PhCapability getCapability(Player player) {
        return (PhCapability)player.getCapability(CAPABILITY).orElse((Object)new PhCapability(player));
    }

    public static void initServer() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)PH_C2S, (buf, context) -> {
            int id = buf.readInt();
            CompoundTag nbt = buf.m_130260_();
            Entity patt0$temp = context.getPlayer().m_9236_().m_6815_(id);
            if (patt0$temp instanceof Player) {
                Player player = (Player)patt0$temp;
                PhCapability.getCapabilityOptional(player).ifPresent(c -> c.deserializeNBT(nbt));
            }
        });
    }
}

