/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.forge.capability.impl.player;

import dev.architectury.networking.NetworkManager;
import net.arna.jcraft.common.component.impl.player.CommonSpecComponentImpl;
import net.arna.jcraft.forge.JNetworkingForge;
import net.arna.jcraft.forge.capability.api.JCapability;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class SpecCapability
extends CommonSpecComponentImpl
implements JCapability {
    public static ResourceLocation SPEC_S2C = new ResourceLocation("jcraft", "spec_s2c");
    public static ResourceLocation SPEC_C2S = new ResourceLocation("jcraft", "spec_c2s");
    public static Capability<SpecCapability> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<SpecCapability>(){});

    public SpecCapability(LivingEntity livingEntity) {
        super(livingEntity);
    }

    @Override
    public void sync(Entity entity) {
        super.sync(entity);
        if (entity != null) {
            SpecCapability.syncEntityCapability(entity);
        }
    }

    public static void syncEntityCapability(Entity entity) {
        if (entity instanceof Player) {
            Player living = (Player)entity;
            JNetworkingForge.sendPackets((Entity)living, SPEC_S2C, SPEC_C2S, SpecCapability.getCapability((LivingEntity)living));
        }
    }

    public static void syncEntityCapability(PlayerEvent.StartTracking event) {
        if (event.getEntity() instanceof Player && event.getEntity().m_9236_() instanceof ServerLevel) {
            SpecCapability.syncEntityCapability((Entity)event.getEntity());
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        super.writeToNbt(tag);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        super.readFromNbt(tag);
    }

    public static LazyOptional<SpecCapability> getCapabilityOptional(LivingEntity livingEntity) {
        return livingEntity.getCapability(CAPABILITY);
    }

    public static SpecCapability getCapability(LivingEntity livingEntity) {
        return (SpecCapability)livingEntity.getCapability(CAPABILITY).orElse((Object)new SpecCapability(livingEntity));
    }

    public static void initServer() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)SPEC_C2S, (buf, context) -> {
            int id = buf.readInt();
            CompoundTag nbt = buf.m_130260_();
            Entity patt0$temp = context.getPlayer().m_9236_().m_6815_(id);
            if (patt0$temp instanceof Player) {
                Player player = (Player)patt0$temp;
                SpecCapability.getCapabilityOptional((LivingEntity)player).ifPresent(c -> c.deserializeNBT(nbt));
            }
        });
    }
}

