/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.forge.client;

import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.networking.NetworkManager;
import me.shedaniel.autoconfig.AutoConfig;
import net.arna.jcraft.api.JRegistries;
import net.arna.jcraft.api.registry.JBlockEntityTypeRegistry;
import net.arna.jcraft.api.registry.JParticleTypeRegistry;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.client.JClientConfig;
import net.arna.jcraft.client.JCraftClient;
import net.arna.jcraft.client.gui.hud.EpitaphOverlay;
import net.arna.jcraft.client.particle.AuraArcParticle;
import net.arna.jcraft.client.particle.AuraBlobParticle;
import net.arna.jcraft.client.particle.BackstabParticle;
import net.arna.jcraft.client.particle.BitesTheDustParticle;
import net.arna.jcraft.client.particle.BlocksparkParticle;
import net.arna.jcraft.client.particle.BoomParticle;
import net.arna.jcraft.client.particle.ComboBreakerParticle;
import net.arna.jcraft.client.particle.CooldownCancelParticle;
import net.arna.jcraft.client.particle.DamageNumberParticle;
import net.arna.jcraft.client.particle.GoParticle;
import net.arna.jcraft.client.particle.HitsparkParticle;
import net.arna.jcraft.client.particle.InversionParticle;
import net.arna.jcraft.client.particle.InvertedHitsparkParticle;
import net.arna.jcraft.client.particle.KCParticle;
import net.arna.jcraft.client.particle.PixelParticle;
import net.arna.jcraft.client.particle.PurpleHazeCloudParticle;
import net.arna.jcraft.client.particle.PurpleHazeErraticParticle;
import net.arna.jcraft.client.particle.SpeedParticle;
import net.arna.jcraft.client.renderer.block.CoffinTileRenderer;
import net.arna.jcraft.forge.JCraftForge;
import net.arna.jcraft.forge.capability.impl.entity.GrabCapability;
import net.arna.jcraft.forge.capability.impl.entity.GravityCapability;
import net.arna.jcraft.forge.capability.impl.entity.TimeStopCapability;
import net.arna.jcraft.forge.capability.impl.living.BombTrackerCapability;
import net.arna.jcraft.forge.capability.impl.living.CooldownsCapability;
import net.arna.jcraft.forge.capability.impl.living.GravityShiftCapability;
import net.arna.jcraft.forge.capability.impl.living.HitPropertyCapability;
import net.arna.jcraft.forge.capability.impl.living.MiscCapability;
import net.arna.jcraft.forge.capability.impl.living.StandCapability;
import net.arna.jcraft.forge.capability.impl.living.VampireCapability;
import net.arna.jcraft.forge.capability.impl.player.PhCapability;
import net.arna.jcraft.forge.capability.impl.player.SpecCapability;
import net.arna.jcraft.forge.capability.impl.world.ShockwaveHandlerCapability;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD, modid="jcraft")
public class JCraftForgeClient {
    @SubscribeEvent
    public static void handleClientSetup(FMLClientSetupEvent event) {
        JCraftClient.init();
        ClientTickEvent.ClientLevel.CLIENT_LEVEL_POST.register(JCraftForge::tickWorldCaps);
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((minecraft, screen) -> (Screen)AutoConfig.getConfigScreen(JClientConfig.class, (Screen)screen).get()));
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)JBlockEntityTypeRegistry.COFFIN_TILE.get()), CoffinTileRenderer::new);
        JCraftForgeClient.registerClientCapabilityReceivers();
        Minecraft.m_91087_().m_6937_(EpitaphOverlay::preload);
    }

    @SubscribeEvent
    public static void onParticleFactoryRegistration(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)JParticleTypeRegistry.COMBO_BREAK.get(), ComboBreakerParticle.Factory::new);
        event.registerSpriteSet((ParticleType)JParticleTypeRegistry.COOLDOWN_CANCEL.get(), CooldownCancelParticle.Factory::new);
        event.registerSpriteSet((ParticleType)JParticleTypeRegistry.HITSPARK_1.get(), provider -> new HitsparkParticle.Factory(provider, 0.4f, 5));
        event.registerSpriteSet((ParticleType)JParticleTypeRegistry.HITSPARK_2.get(), provider -> new HitsparkParticle.Factory(provider, 0.66f, 6));
        event.registerSpriteSet((ParticleType)JParticleTypeRegistry.HITSPARK_3.get(), provider -> new HitsparkParticle.Factory(provider, 1.0f, 8));
        event.registerSpriteSet((ParticleType)JParticleTypeRegistry.INVERTED_HITSPARK_3.get(), provider -> new InvertedHitsparkParticle.Factory(provider, 1.0f, 8));
        event.registerSpriteSet((ParticleType)JParticleTypeRegistry.STUN_SLASH.get(), provider -> new HitsparkParticle.Factory(provider, 0.6f, 6));
        event.registerSpriteSet((ParticleType)JParticleTypeRegistry.STUN_PIERCE.get(), provider -> new HitsparkParticle.Factory(provider, 0.6f, 6));
        event.registerSpriteSet((ParticleType)JParticleTypeRegistry.KCPARTICLE.get(), KCParticle.Factory::new);
        event.registerSpriteSet((ParticleType)JParticleTypeRegistry.BACKSTAB.get(), BackstabParticle.Factory::new);
        event.registerSpriteSet((ParticleType)JParticleTypeRegistry.SPEED_PARTICLE.get(), SpeedParticle.Factory::new);
        event.registerSpriteSet((ParticleType)JParticleTypeRegistry.BITES_THE_DUST.get(), BitesTheDustParticle.Factory::new);
        event.registerSpriteSet((ParticleType)JParticleTypeRegistry.BOOM_1.get(), BoomParticle.Factory::new);
        event.registerSpriteSet((ParticleType)JParticleTypeRegistry.PIXEL.get(), PixelParticle.Factory::new);
        event.registerSpriteSet((ParticleType)JParticleTypeRegistry.BLOCKSPARK.get(), provider -> new BlocksparkParticle.Factory(provider, 0.15f));
        event.registerSpriteSet((ParticleType)JParticleTypeRegistry.GO.get(), GoParticle.Factory::new);
        event.registerSpriteSet((ParticleType)JParticleTypeRegistry.AURA_ARC.get(), AuraArcParticle.Factory::new);
        event.registerSpriteSet((ParticleType)JParticleTypeRegistry.AURA_BLOB.get(), AuraBlobParticle.Factory::new);
        event.registerSpriteSet((ParticleType)JParticleTypeRegistry.INVERSION.get(), InversionParticle.Factory::new);
        event.registerSpriteSet((ParticleType)JParticleTypeRegistry.SUN_LOCK_ON.get(), BackstabParticle.Factory::new);
        event.registerSpriteSet((ParticleType)JParticleTypeRegistry.PURPLE_HAZE_CLOUD.get(), PurpleHazeCloudParticle.Factory::new);
        event.registerSpriteSet((ParticleType)JParticleTypeRegistry.PURPLE_HAZE_PARTICLE.get(), PurpleHazeErraticParticle.Factory::new);
        event.registerSpriteSet((ParticleType)JParticleTypeRegistry.DAMAGE_NUMBER.get(), DamageNumberParticle.Factory::new);
    }

    private static void registerClientCapabilityReceivers() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)GrabCapability.GRAB_S2C, (buf, context) -> {
            int id = buf.m_130242_();
            if (Minecraft.m_91087_().f_91073_ != null) {
                Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(id);
                if (entity == null) {
                    return;
                }
                GrabCapability.getCapabilityOptional(entity).ifPresent(c -> c.applySyncPacket(buf));
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)GravityCapability.G_S2C, (buf, context) -> {
            Entity patt0$temp;
            int id = buf.readInt();
            CompoundTag nbt = buf.m_130260_();
            if (Minecraft.m_91087_().f_91073_ != null && (patt0$temp = Minecraft.m_91087_().f_91073_.m_6815_(id)) instanceof Player) {
                Player player = (Player)patt0$temp;
                GravityCapability.getCapabilityOptional((Entity)player).ifPresent(c -> c.deserializeNBT(nbt));
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)TimeStopCapability.TIME_S2C, (buf, context) -> {
            Entity patt0$temp;
            int id = buf.readInt();
            CompoundTag nbt = buf.m_130260_();
            if (Minecraft.m_91087_().f_91073_ != null && (patt0$temp = Minecraft.m_91087_().f_91073_.m_6815_(id)) instanceof Player) {
                Player player = (Player)patt0$temp;
                TimeStopCapability.getCapabilityOptional((Entity)player).ifPresent(c -> c.deserializeNBT(nbt));
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)BombTrackerCapability.BOMB_S2C, (buf, context) -> {
            LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
            if (localPlayer != null) {
                BombTrackerCapability.getCapabilityOptional((Entity)localPlayer).ifPresent(c -> c.applySyncPacket(buf));
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)CooldownsCapability.CD_S2C, (buf, context) -> {
            Entity patt0$temp;
            int id = buf.readInt();
            CompoundTag nbt = buf.m_130260_();
            if (Minecraft.m_91087_().f_91073_ != null && (patt0$temp = Minecraft.m_91087_().f_91073_.m_6815_(id)) instanceof Player) {
                Player player = (Player)patt0$temp;
                CooldownsCapability.getCapabilityOptional((Entity)player).ifPresent(c -> c.deserializeNBT(nbt));
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)GravityShiftCapability.GS_S2C, (buf, context) -> {
            Entity patt0$temp;
            int id = buf.readInt();
            CompoundTag nbt = buf.m_130260_();
            if (Minecraft.m_91087_().f_91073_ != null && (patt0$temp = Minecraft.m_91087_().f_91073_.m_6815_(id)) instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)patt0$temp;
                GravityShiftCapability.getCapability(living).deserializeNBT(nbt);
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)HitPropertyCapability.HIT_S2C, (buf, context) -> {
            Entity patt0$temp;
            int id = buf.m_130242_();
            if (Minecraft.m_91087_().f_91073_ != null && (patt0$temp = Minecraft.m_91087_().f_91073_.m_6815_(id)) instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)patt0$temp;
                HitPropertyCapability.getCapabilityOptional((Entity)livingEntity).ifPresent(capability -> capability.applySyncPacket(buf));
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)MiscCapability.MISC_S2C, (buf, context) -> {
            Entity patt0$temp;
            int id = buf.readInt();
            CompoundTag nbt = buf.m_130260_();
            if (Minecraft.m_91087_().f_91073_ != null && (patt0$temp = Minecraft.m_91087_().f_91073_.m_6815_(id)) instanceof Player) {
                Player player = (Player)patt0$temp;
                MiscCapability.getCapabilityOptional((Entity)player).ifPresent(c -> c.deserializeNBT(nbt));
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)StandCapability.STAND_S2C, (buf, context) -> {
            Entity patt0$temp;
            int id = buf.readInt();
            boolean noStand = buf.readBoolean();
            ResourceLocation standTypeId = noStand ? null : buf.m_130281_();
            StandType standType = standTypeId == null ? null : (StandType)JRegistries.STAND_TYPE_REGISTRY.get(standTypeId);
            int skin = buf.readInt();
            if (Minecraft.m_91087_().f_91073_ != null && (patt0$temp = Minecraft.m_91087_().f_91073_.m_6815_(id)) instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)patt0$temp;
                StandCapability.getCapabilityOptional((Entity)livingEntity).ifPresent(c -> {
                    c.setTypeAndSkin(standType, skin);
                    c.applySyncPacket(buf);
                });
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)VampireCapability.VAMP_S2C, (buf, context) -> {
            LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
            if (localPlayer != null) {
                VampireCapability.getCapabilityOptional((Entity)localPlayer).ifPresent(c -> c.applySyncPacket(buf));
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)PhCapability.PH_S2C, (buf, context) -> {
            Entity patt0$temp;
            int id = buf.readInt();
            CompoundTag nbt = buf.m_130260_();
            if (Minecraft.m_91087_().f_91073_ != null && (patt0$temp = Minecraft.m_91087_().f_91073_.m_6815_(id)) instanceof Player) {
                Player player = (Player)patt0$temp;
                PhCapability.getCapabilityOptional(player).ifPresent(c -> c.deserializeNBT(nbt));
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)SpecCapability.SPEC_S2C, (buf, context) -> {
            Entity patt0$temp;
            int id = buf.readInt();
            CompoundTag nbt = buf.m_130260_();
            if (Minecraft.m_91087_().f_91073_ != null && (patt0$temp = Minecraft.m_91087_().f_91073_.m_6815_(id)) instanceof Player) {
                Player player = (Player)patt0$temp;
                SpecCapability.getCapabilityOptional((LivingEntity)player).ifPresent(c -> c.deserializeNBT(nbt));
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)ShockwaveHandlerCapability.SHOCK_S2C, (buf, context) -> {
            ClientLevel clientWorld = Minecraft.m_91087_().f_91073_;
            if (clientWorld == null) {
                return;
            }
            ShockwaveHandlerCapability.getCapabilityOptional((Level)clientWorld).ifPresent(shockwaveCap -> shockwaveCap.applySyncPacket(buf));
        });
    }
}

