/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.forge.events;

import com.mojang.blaze3d.vertex.PoseStack;
import net.arna.jcraft.client.events.JClientEvents;
import net.arna.jcraft.client.renderer.effects.AttackHitboxEffectRenderer;
import net.arna.jcraft.client.renderer.effects.ShockwaveEffectRenderer;
import net.arna.jcraft.client.renderer.effects.SplatterEffectRenderer;
import net.arna.jcraft.client.renderer.effects.TimeAccelerationEffectRenderer;
import net.arna.jcraft.client.renderer.effects.TimeErasePredictionEffectRenderer;
import net.arna.jcraft.forge.mixin.client.LevelRendererAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientRuntimeEvents {
    @SubscribeEvent
    public static void renderTickStart(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null) {
                TimeAccelerationEffectRenderer.render(level);
            }
        } else {
            JClientEvents.onLast(new PoseStack(), Minecraft.m_91087_().f_91063_.m_109153_().m_90583_());
        }
    }

    @SubscribeEvent
    public static void renderLevel(RenderLevelStageEvent event) {
        RenderBuffers renderBuffers = ((LevelRendererAccessor)event.getLevelRenderer()).getRenderBuffers();
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            JClientEvents.afterTranslucent(event.getPoseStack(), event.getCamera().m_90583_(), event.getLevelRenderer());
        }
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_ENTITIES) {
            AttackHitboxEffectRenderer.render(event.getPoseStack(), event.getCamera().m_90583_(), event.getLevelRenderer(), (MultiBufferSource)renderBuffers.m_110104_());
            ShockwaveEffectRenderer.render(event.getPoseStack(), event.getCamera().m_90583_(), level, (MultiBufferSource)renderBuffers.m_110104_());
            SplatterEffectRenderer.render(event.getPoseStack(), event.getCamera().m_90583_(), level, event.getPartialTick());
            TimeErasePredictionEffectRenderer.render(event.getPoseStack(), event.getCamera().m_90583_(), level, event.getPartialTick(), (MultiBufferSource)renderBuffers.m_110104_());
        }
    }
}

