/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.forge.events;

import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.component.JComponent;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.common.block.tile.CoffinTileEntity;
import net.arna.jcraft.forge.capability.api.JCapabilityProvider;
import net.arna.jcraft.forge.capability.impl.entity.GrabCapability;
import net.arna.jcraft.forge.capability.impl.entity.GravityCapability;
import net.arna.jcraft.forge.capability.impl.entity.TimeStopCapability;
import net.arna.jcraft.forge.capability.impl.living.BombTrackerCapability;
import net.arna.jcraft.forge.capability.impl.living.CooldownsCapability;
import net.arna.jcraft.forge.capability.impl.living.GravityShiftCapability;
import net.arna.jcraft.forge.capability.impl.living.HitPropertyCapability;
import net.arna.jcraft.forge.capability.impl.living.MiscCapability;
import net.arna.jcraft.forge.capability.impl.living.StandCapability;
import net.arna.jcraft.forge.capability.impl.living.VampireCapability;
import net.arna.jcraft.forge.capability.impl.player.PhCapability;
import net.arna.jcraft.forge.capability.impl.player.SpecCapability;
import net.arna.jcraft.forge.capability.impl.world.ShockwaveHandlerCapability;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingBreatheEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.SleepingTimeCheckEvent;
import net.minecraftforge.event.level.SleepFinishedTimeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class RuntimeEvents {
    @SubscribeEvent
    public static void attachEntityCapability(AttachCapabilitiesEvent<Entity> event) {
        Entity object = (Entity)event.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            event.addCapability(JCraft.id("ph_capability"), new JCapabilityProvider<PhCapability>(PhCapability.CAPABILITY, () -> new PhCapability(player)));
        }
        if (object instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)object;
            event.addCapability(JCraft.id("bomb_capability"), new JCapabilityProvider<BombTrackerCapability>(BombTrackerCapability.CAPABILITY, () -> new BombTrackerCapability(living)));
            event.addCapability(JCraft.id("cd_capability"), new JCapabilityProvider<CooldownsCapability>(CooldownsCapability.CAPABILITY, () -> new CooldownsCapability(living)));
            event.addCapability(JCraft.id("hit_capability"), new JCapabilityProvider<HitPropertyCapability>(HitPropertyCapability.CAPABILITY, () -> new HitPropertyCapability(living)));
            event.addCapability(JCraft.id("misc_capability"), new JCapabilityProvider<MiscCapability>(MiscCapability.CAPABILITY, () -> new MiscCapability(living)));
            event.addCapability(JCraft.id("stand_capability"), new JCapabilityProvider<StandCapability>(StandCapability.CAPABILITY, () -> new StandCapability(living)));
            event.addCapability(JCraft.id("vampire_capability"), new JCapabilityProvider<VampireCapability>(VampireCapability.CAPABILITY, () -> new VampireCapability(living)));
            event.addCapability(JCraft.id("gravity_shift_capability"), new JCapabilityProvider<GravityShiftCapability>(GravityShiftCapability.CAPABILITY, () -> new GravityShiftCapability(living)));
            event.addCapability(JCraft.id("spec_capability"), new JCapabilityProvider<SpecCapability>(SpecCapability.CAPABILITY, () -> new SpecCapability(living)));
        }
        event.addCapability(JCraft.id("gravity_capability"), new JCapabilityProvider<GravityCapability>(GravityCapability.CAPABILITY, () -> new GravityCapability(object)));
        event.addCapability(JCraft.id("grab_capability"), new JCapabilityProvider<GrabCapability>(GrabCapability.CAPABILITY, () -> new GrabCapability(object)));
        event.addCapability(JCraft.id("time_capability"), new JCapabilityProvider<TimeStopCapability>(TimeStopCapability.CAPABILITY, () -> new TimeStopCapability(object)));
    }

    @SubscribeEvent
    public static void attachWorldCapability(AttachCapabilitiesEvent<Level> event) {
        event.addCapability(JCraft.id("shock_capability"), new JCapabilityProvider<ShockwaveHandlerCapability>(ShockwaveHandlerCapability.CAPABILITY, () -> new ShockwaveHandlerCapability((Level)event.getObject())));
    }

    @SubscribeEvent
    public static void entityJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            PhCapability.syncEntityCapability((Entity)serverPlayer);
            SpecCapability.syncEntityCapability((Entity)serverPlayer);
        }
        TimeStopCapability.getCapability(event.getEntity());
    }

    @SubscribeEvent
    public static void syncEntityCapability(PlayerEvent.StartTracking event) {
        TimeStopCapability.syncEntityCapability(event);
        CooldownsCapability.syncEntityCapability(event);
        MiscCapability.syncEntityCapability(event);
        StandCapability.syncEntityCapability(event);
        PhCapability.syncEntityCapability(event);
        SpecCapability.syncEntityCapability(event);
        GravityCapability.syncEntityCapability(event);
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        PhCapability.getCapabilityOptional(event.player).ifPresent(c -> {});
        SpecCapability.getCapabilityOptional((LivingEntity)event.player).ifPresent(c -> {});
    }

    @SubscribeEvent
    public static void playerClone(PlayerEvent.Clone event) {
        event.getOriginal().reviveCaps();
        RuntimeEvents.copyCapability(PhCapability.CAPABILITY, (Entity)event.getOriginal(), (Entity)event.getEntity());
        RuntimeEvents.copyCapability(SpecCapability.CAPABILITY, (Entity)event.getOriginal(), (Entity)event.getEntity());
        RuntimeEvents.copyCapability(BombTrackerCapability.CAPABILITY, (Entity)event.getOriginal(), (Entity)event.getEntity());
        RuntimeEvents.copyCapability(CooldownsCapability.CAPABILITY, (Entity)event.getOriginal(), (Entity)event.getEntity());
        RuntimeEvents.copyCapability(HitPropertyCapability.CAPABILITY, (Entity)event.getOriginal(), (Entity)event.getEntity());
        RuntimeEvents.copyCapability(MiscCapability.CAPABILITY, (Entity)event.getOriginal(), (Entity)event.getEntity());
        RuntimeEvents.copyCapability(StandCapability.CAPABILITY, (Entity)event.getOriginal(), (Entity)event.getEntity());
        RuntimeEvents.copyCapability(VampireCapability.CAPABILITY, (Entity)event.getOriginal(), (Entity)event.getEntity());
        RuntimeEvents.copyCapability(GrabCapability.CAPABILITY, (Entity)event.getOriginal(), (Entity)event.getEntity());
        RuntimeEvents.copyCapability(TimeStopCapability.CAPABILITY, (Entity)event.getOriginal(), (Entity)event.getEntity());
        event.getOriginal().invalidateCaps();
    }

    private static <C extends JComponent> void copyCapability(Capability<C> cap, Entity from, Entity to) {
        from.getCapability(cap).ifPresent(c -> to.getCapability(cap).ifPresent(c2 -> {
            CompoundTag tag = new CompoundTag();
            c.writeToNbt(tag);
            c2.readFromNbt(tag);
        }));
    }

    @SubscribeEvent
    public static void coffinSleepCheck(SleepingTimeCheckEvent event) {
        BlockPos pos;
        BlockEntity bed;
        Level world = event.getEntity().m_9236_();
        if (event.getSleepingLocation().isPresent() && (bed = world.m_7702_(pos = (BlockPos)event.getSleepingLocation().get())) instanceof CoffinTileEntity) {
            if (world.m_46461_()) {
                event.setResult(Event.Result.ALLOW);
            } else {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public static void coffinWakeUpTime(SleepFinishedTimeEvent event) {
        LevelAccessor world = event.getLevel();
        if (world.m_8044_() % 24000L < 12000L) {
            event.setTimeAddition(world.m_8044_() / 24000L * 24000L + 13000L);
        }
    }

    @SubscribeEvent
    public static void stopBreathing(LivingBreatheEvent event) {
        event.setCanRefillAir(!event.getEntity().m_21023_((MobEffect)JStatusRegistry.HYPOXIA.get()));
    }
}

