/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.forge.mixin;

import net.arna.jcraft.common.util.InputStateManager;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.mixin_logic.ServerPlayerEntityMixinLogic;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.util.ITeleporter;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayer.class})
public class ServerPlayerEntityMixin {
    @Unique
    private boolean hadStand = false;
    @Unique
    private final InputStateManager inputStateManager = new InputStateManager();

    @Inject(method={"changeDimension(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraftforge/common/util/ITeleporter;)Lnet/minecraft/world/entity/Entity;"}, at={@At(value="HEAD")}, remap=false)
    private void saveStandStateBeforeWorldMove(ServerLevel arg, ITeleporter teleporter, CallbackInfoReturnable<Entity> cir) {
        this.hadStand = JUtils.getStand((LivingEntity)((ServerPlayer)this)) != null;
    }

    @Inject(method={"changeDimension"}, at={@At(value="FIELD", target="Lnet/minecraft/server/level/ServerPlayer;lastSentFood:I", shift=At.Shift.AFTER)})
    private void resummonStandAfterWorldMove(ServerLevel destination, ITeleporter teleporter, CallbackInfoReturnable<Entity> cir) {
        ServerPlayerEntityMixinLogic.resummonStandAfterWorldMove((ServerPlayer)this, this.hadStand, destination, cir);
    }

    @Inject(method={"changeDimension"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;removePlayerImmediately(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/entity/Entity$RemovalReason;)V")})
    private void doNotPlayDesummonSoundWhenMovingWorld(ServerLevel arg, ITeleporter teleporter, CallbackInfoReturnable<Entity> cir) {
        ServerPlayerEntityMixinLogic.doNotPlayDesummonSoundWhenMovingWorld((ServerPlayer)this, arg, cir);
    }
}

