/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import java.util.Map;
import net.arna.jcraft.api.registry.JItemRegistry;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.common.enchantments.CinderellasKissEnchantment;
import net.arna.jcraft.common.item.StandDiscItem;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AnvilMenu.class})
public abstract class AnvilMenuMixin
extends ItemCombinerMenu {
    @Shadow
    @Final
    private DataSlot f_39002_;

    private AnvilMenuMixin(@Nullable MenuType<?> type, int containerId, Inventory playerInventory, ContainerLevelAccess access) {
        super(type, containerId, playerInventory, access);
    }

    @Inject(method={"createResult"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isDamageableItem()Z", ordinal=0)})
    private void injectStandSkinRecipe(CallbackInfo ci, @Local(ordinal=1) ItemStack result) {
        ItemStack item2;
        ItemStack item1 = this.f_39769_.m_8020_(0);
        if (!AnvilMenuMixin.isValidStandSkinRecipe(item1, item2 = this.f_39769_.m_8020_(1))) {
            return;
        }
        int level = CinderellasKissEnchantment.getCKLevel(item2);
        StandDiscItem.setSkin(result, level);
        this.f_39002_.m_6422_(5);
    }

    @ModifyVariable(method={"createResult"}, at=@At(value="LOAD", ordinal=0), index=8)
    private boolean modifyReturnCondition1(boolean isValid) {
        return isValid || AnvilMenuMixin.isValidStandSkinRecipe(this.f_39769_.m_8020_(0), this.f_39769_.m_8020_(1));
    }

    @Redirect(method={"createResult"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/enchantment/EnchantmentHelper;getEnchantments(Lnet/minecraft/world/item/ItemStack;)Ljava/util/Map;", ordinal=1))
    private Map<Enchantment, Integer> modifyMaskEnchantments(ItemStack stack) {
        return stack.m_150930_((Item)JItemRegistry.CINDERELLA_MASK.get()) ? Map.of() : EnchantmentHelper.m_44831_((ItemStack)stack);
    }

    @ModifyVariable(method={"createResult"}, at=@At(value="LOAD"), index=10)
    private boolean modifyReturnCondition2(boolean isNotValid) {
        return isNotValid && !AnvilMenuMixin.isValidStandSkinRecipe(this.f_39769_.m_8020_(0), this.f_39769_.m_8020_(1));
    }

    @ModifyArg(method={"createResult"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/inventory/DataSlot;set(I)V", ordinal=5))
    private int modifyCost(int cost, @Local(ordinal=0) LocalIntRef i) {
        if (this.f_39769_.m_8020_(1).m_150930_((Item)JItemRegistry.CINDERELLA_MASK.get())) {
            i.set(5);
            return cost + 5;
        }
        return cost;
    }

    @ModifyExpressionValue(method={"createResult"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isEmpty()Z", ordinal=3)})
    private boolean modifyRepairCostCondition(boolean b) {
        return !this.f_39769_.m_8020_(1).m_150930_((Item)JItemRegistry.CINDERELLA_MASK.get()) && b;
    }

    @Unique
    private static boolean isValidStandSkinRecipe(ItemStack item1, ItemStack item2) {
        if (item1.m_41720_() != JItemRegistry.STAND_DISC.get() || item2.m_41720_() != JItemRegistry.CINDERELLA_MASK.get()) {
            return false;
        }
        StandType standType = StandDiscItem.getStandType(item1);
        if (standType == null) {
            return false;
        }
        int level = CinderellasKissEnchantment.getCKLevel(item2);
        return level <= standType.getData().getInfo().getSkinCount() - 1 && level != StandDiscItem.getSkin(item1);
    }
}

