/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.mixin;

import java.util.Optional;
import java.util.function.Function;
import net.arna.jcraft.api.stand.StandTypeUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityType.class})
public class EntityTypeMixin {
    @Unique
    private static int shouldLoadStands = 0;

    @Inject(method={"create(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/world/level/Level;)Ljava/util/Optional;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void doNotLoadStandEntities(CompoundTag nbt, Level world, CallbackInfoReturnable<Optional<Entity>> cir) {
        if (shouldLoadStands > 0) {
            return;
        }
        EntityType entityType = (EntityType)BuiltInRegistries.f_256780_.m_7745_(new ResourceLocation(nbt.m_128461_("id")));
        if (StandTypeUtil.streamEntityTypes().toList().contains(entityType)) {
            cir.setReturnValue(Optional.empty());
        }
    }

    @Inject(method={"method_17843"}, at={@At(value="HEAD")})
    private static void doLoadStandsWhenLoadingArmorStandPre(CompoundTag nbtCompound, Level world, Function<Entity, Entity> function, Entity entity, CallbackInfoReturnable<Entity> cir) {
        if (entity instanceof ArmorStand) {
            shouldLoadStands = Math.max(1, shouldLoadStands + 1);
        }
    }

    @Inject(method={"method_17843"}, at={@At(value="RETURN")})
    private static void doLoadStandsWhenLoadingArmorStandPost(CompoundTag nbtCompound, Level world, Function<Entity, Entity> function, Entity entity, CallbackInfoReturnable<Entity> cir) {
        if (entity instanceof ArmorStand) {
            --shouldLoadStands;
        }
    }
}

