/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.mixin;

import dev.architectury.platform.Platform;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.resources.FallbackResourceManager;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceMetadata;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FallbackResourceManager.class})
public class FallbackResourceManagerMixin {
    @Inject(method={"createResource"}, at={@At(value="HEAD")}, cancellable=true)
    private static void createDirectResource(PackResources source, ResourceLocation location, IoSupplier<InputStream> streamSupplier, IoSupplier<ResourceMetadata> metadataSupplier, CallbackInfoReturnable<Resource> cir) {
        if (!(Platform.isDevelopmentEnvironment() && "jcraft".equals(location.m_135827_()) && location.m_135815_().startsWith("movesets/"))) {
            return;
        }
        Path p = Path.of("./../../common/src/main/generated/data/" + location.m_135827_() + "/" + location.m_135815_(), new String[0]);
        if (Files.exists(p, new LinkOption[0])) {
            cir.setReturnValue((Object)new Resource(source, () -> Files.newInputStream(p, new OpenOption[0]), metadataSupplier));
        }
    }
}

