/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.mixin;

import net.arna.jcraft.common.item.MockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public class ItemStackMixin {
    @Inject(method={"is(Lnet/minecraft/world/item/Item;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void mockItem(Item item, CallbackInfoReturnable<Boolean> cir) {
        ItemStack thiz = (ItemStack)this;
        if (MockItem.isMockItem(thiz)) {
            cir.setReturnValue((Object)MockItem.getMockedStack(thiz).m_150930_(item));
        }
    }

    @Inject(method={"matches"}, at={@At(value="HEAD")}, cancellable=true)
    private static void mockItemEqualsCheck(ItemStack left, ItemStack right, CallbackInfoReturnable<Boolean> cir) {
        if (!MockItem.isMockItem(left) && !MockItem.isMockItem(right)) {
            return;
        }
        ItemStack stack1 = MockItem.isMockItem(left) ? MockItem.getMockedStack(left) : left;
        ItemStack stack2 = MockItem.isMockItem(right) ? MockItem.getMockedStack(right) : right;
        cir.setReturnValue((Object)ItemStack.m_41728_((ItemStack)stack1, (ItemStack)stack2));
    }
}

