/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.mixin;

import java.util.Objects;
import net.arna.jcraft.common.events.JBlockEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Level.class})
public class LevelMixin {
    @Unique
    private static final String MINECRAFT_SERVER_NAME = MinecraftServer.class.getName();
    @Unique
    private static final String LEVEL_CHUNK_NAME = LevelChunk.class.getName();

    @Inject(method={"setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;I)Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void jcraft$setBlock(BlockPos pos, BlockState newState, int flags, CallbackInfoReturnable<Boolean> cir) {
        Level level = (Level)this;
        if (!level.m_5776_()) {
            BlockState oldState = level.m_8055_(pos);
            if (Objects.equals(oldState, newState)) {
                return;
            }
            for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
                if ((!MINECRAFT_SERVER_NAME.equals(element.getClassName()) || !"prepareLevels".equals(element.getMethodName())) && (!LEVEL_CHUNK_NAME.equals(element.getClassName()) || !"postProcessGeneration".equals(element.getMethodName()))) continue;
                return;
            }
            if (((JBlockEvents.BeforeSet)JBlockEvents.BEFORE_SET.invoker()).setBlock(pos, oldState, newState).interruptsFurtherEvaluation()) {
                cir.setReturnValue((Object)false);
                cir.cancel();
            }
        }
    }
}

