/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.mixin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import lombok.NonNull;
import net.arna.jcraft.api.Attacks;
import net.arna.jcraft.api.MoveUsage;
import net.arna.jcraft.api.attack.moves.AbstractCounterAttack;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.api.registry.JTagRegistry;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.config.JServerConfig;
import net.arna.jcraft.common.entity.stand.KingCrimsonEntity;
import net.arna.jcraft.common.network.s2c.IPSTriggeredPacket;
import net.arna.jcraft.common.util.IJCraftComboTracker;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
implements IJCraftComboTracker {
    @Shadow
    protected int f_20889_;
    @Shadow
    @Nullable
    protected Player f_20888_;
    @Unique
    private float damageScaling = 1.0f;
    @Unique
    private int hitCount = 0;
    @Unique
    private final Map<LivingEntity, HashSet<MoveUsage>> usedComboMoves = new HashMap<LivingEntity, HashSet<MoveUsage>>();

    @Override
    public float jcraft$getDamageScaling() {
        return this.damageScaling;
    }

    @Override
    public int jcraft$getHitCount() {
        return this.hitCount;
    }

    @Override
    public void jcraft$increaseHitCount() {
        ++this.hitCount;
        this.damageScaling = Math.max(JServerConfig.DAMAGE_SCALING_MINIMUM.getValue(), this.damageScaling - JServerConfig.SCALING_PENALTY_PER_HIT.getValue());
    }

    @Override
    public boolean jcraft$addMoveToCombo(@NonNull LivingEntity attacker, MoveUsage moveUsage) {
        if (attacker == null) {
            throw new NullPointerException("attacker is marked non-null but is null");
        }
        if (this.usedComboMoves.containsKey(attacker)) {
            AbstractMove<?, ?> move = moveUsage.move();
            HashSet<MoveUsage> moveList = this.usedComboMoves.get(attacker);
            for (MoveUsage pastUsage : moveList) {
                if (moveUsage == pastUsage || !Attacks.prototypeMatch(pastUsage.move(), move)) continue;
                LivingEntity attackerUser = JUtils.getUserIfStand(attacker);
                if (attackerUser instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)attackerUser;
                    IPSTriggeredPacket.send(serverPlayer);
                }
                return true;
            }
            if (move.isLoopPrevention()) {
                moveList.add(moveUsage);
                return false;
            }
        } else {
            AbstractMove<?, ?> move = moveUsage.move();
            HashSet<MoveUsage> moveList = new HashSet<MoveUsage>(2);
            if (move.isLoopPrevention()) {
                moveList.add(moveUsage);
                this.usedComboMoves.put(attacker, moveList);
            }
        }
        return false;
    }

    @Override
    public boolean jcraft$comboFromAttackerContains(LivingEntity attacker, AbstractMove<?, ?> move) {
        if (!this.usedComboMoves.containsKey(attacker)) {
            return false;
        }
        for (MoveUsage moveUsage : this.usedComboMoves.get(attacker)) {
            if (!Attacks.prototypeMatch(moveUsage.move(), move)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void jcraft$resetCombo() {
        for (Map.Entry<LivingEntity, HashSet<MoveUsage>> entry : this.usedComboMoves.entrySet()) {
            entry.getValue().clear();
        }
        this.damageScaling = 1.0f;
        this.hitCount = 0;
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;aiStep()V", shift=At.Shift.AFTER)})
    public void jcraft$tick(CallbackInfo callbackInfo) {
        LivingEntity living = (LivingEntity)LivingEntity.class.cast(this);
        if (this.hitCount > 0 && !living.m_21023_((MobEffect)JStatusRegistry.DAZED.get())) {
            this.jcraft$resetCombo();
        }
    }

    @Inject(cancellable=true, method={"setLastHurtMob"}, at={@At(value="HEAD")})
    public void jcraft$onAttacking(Entity target, CallbackInfo info) {
        if (JUtils.isAffectedByTimeStop((Entity)((LivingEntity)this))) {
            info.cancel();
        }
    }

    @Inject(cancellable=true, method={"getJumpBoostPower"}, at={@At(value="HEAD")})
    public void jcraft$getJumpBoostVelocityModifier(CallbackInfoReturnable<Float> cir) {
        LivingEntity entity = (LivingEntity)this;
        if (!JUtils.canJump(entity)) {
            cir.setReturnValue((Object)Float.valueOf(-1.0f));
        }
    }

    @Inject(cancellable=true, method={"jumpFromGround"}, at={@At(value="HEAD")})
    public void jcraft$jumpFromGround(CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        if (!JUtils.canJump(entity)) {
            ci.cancel();
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"hurt"})
    private void hurt(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity user;
        StandEntity stand;
        Entity entity;
        if (cir.getReturnValueZ() && (entity = source.m_7639_()) instanceof StandEntity && (stand = (StandEntity)entity).hasUser() && (user = stand.getUser()) instanceof Player) {
            Player player = (Player)user;
            this.f_20889_ = 100;
            this.f_20888_ = player;
        }
    }

    @Inject(cancellable=true, at={@At(value="HEAD")}, method={"actuallyHurt"})
    protected void jcraft$applyDamage(DamageSource source, float amount, CallbackInfo info) {
        LivingEntity player = (LivingEntity)this;
        Entity entity = player.m_146895_();
        if (!(entity instanceof StandEntity)) {
            return;
        }
        StandEntity stand = (StandEntity)entity;
        AbstractMove attack = stand.getCurrentMove();
        if (attack == null || !attack.isCounter() || stand.getMoveStun() >= attack.getDuration() - attack.getWindup()) {
            return;
        }
        ((AbstractCounterAttack)attack).counter(stand, source.m_7639_(), source);
        player.m_21195_((MobEffect)JStatusRegistry.DAZED.get());
        info.cancel();
    }

    @Inject(cancellable=true, method={"hasLineOfSight"}, at={@At(value="HEAD")})
    public void jcraft$canSee(Entity entity, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity livingEntity = (LivingEntity)this;
        LivingEntityMixin.doChecks(entity, cir, livingEntity);
    }

    @Inject(cancellable=true, method={"canAttack(Lnet/minecraft/world/entity/LivingEntity;)Z"}, at={@At(value="HEAD")})
    public void jcraft$canTarget(LivingEntity target, CallbackInfoReturnable<Boolean> cir) {
        LivingEntityMixin.doChecks((Entity)target, cir, (LivingEntity)this);
    }

    @Inject(cancellable=true, at={@At(value="HEAD")}, method={"tickEffects"})
    protected void jcraft$tickStatusEffects(CallbackInfo ci) {
        if (JComponentPlatformUtils.getTimeStopData((Entity)((LivingEntity)this)).isPresent() && JComponentPlatformUtils.getTimeStopData((Entity)((LivingEntity)this)).get().getTicks() > 0) {
            ci.cancel();
        }
    }

    @Unique
    private static void doChecks(Entity entity, CallbackInfoReturnable<Boolean> cir, LivingEntity livingEntity) {
        KingCrimsonEntity kingCrimson;
        Entity entity2;
        if ((livingEntity.m_21023_((MobEffect)JStatusRegistry.DAZED.get()) && !JUtils.isBlocking(livingEntity) || livingEntity.m_21023_((MobEffect)JStatusRegistry.KNOCKDOWN.get())) && !livingEntity.m_6095_().m_204039_(JTagRegistry.CANNOT_BE_STUNNED)) {
            cir.setReturnValue((Object)false);
        }
        if ((entity2 = entity.m_146895_()) instanceof KingCrimsonEntity && (kingCrimson = (KingCrimsonEntity)entity2).getTETime() > 0) {
            cir.setReturnValue((Object)false);
        }
        if (JComponentPlatformUtils.getMiscData(livingEntity).getMaster() == entity) {
            cir.setReturnValue((Object)false);
        }
    }
}

