/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.mixin;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import net.arna.jcraft.api.attack.moves.AbstractCounterAttack;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.api.spec.JSpec;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.config.JServerConfig;
import net.arna.jcraft.common.network.s2c.ComboCounterPacket;
import net.arna.jcraft.common.util.IComboCounter;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin
implements IComboCounter {
    @Unique
    private int comboCount = 1;
    @Unique
    private LivingEntity lastAttacked;

    @Override
    public LivingEntity jcraft$getLastAttacked() {
        return this.lastAttacked;
    }

    @Override
    public void jcraft$setLastAttacked(LivingEntity l) {
        this.lastAttacked = l;
    }

    @Override
    public int jcraft$getComboCount() {
        return this.comboCount;
    }

    @Override
    public void jcraft$setComboCount(int i) {
        this.comboCount = i;
    }

    @Override
    public void jcraft$incrementComboCount() {
        ++this.comboCount;
    }

    @WrapWithCondition(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;touch(Lnet/minecraft/world/entity/Entity;)V")})
    public boolean dontHandleTouchInTimestop(Player player, Entity entity) {
        return !JUtils.isAffectedByTimeStop(entity);
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    public void jcraft$playerTickTail(CallbackInfo info) {
        Player player = (Player)this;
        if (JUtils.isAffectedByTimeStop((Entity)player)) {
            return;
        }
        JSpec<?, ?> spec = JComponentPlatformUtils.getSpecData((LivingEntity)player).getSpec();
        if (spec != null) {
            spec.tickSpec();
        }
        if (this.lastAttacked == null || !this.lastAttacked.m_6084_()) {
            return;
        }
        LivingEntity attacker = this.lastAttacked.m_21188_();
        if (attacker == null || attacker == player) {
            return;
        }
        this.lastAttacked = null;
        this.comboCount = 0;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ComboCounterPacket.send(serverPlayer, 0, 1.0f);
        }
    }

    @Inject(cancellable=true, at={@At(value="HEAD")}, method={"updatePlayerPose"})
    public void jcraft$updatePose(CallbackInfo info) {
        if (((Player)this).m_21023_((MobEffect)JStatusRegistry.KNOCKDOWN.get()) || ((Player)this).m_21023_((MobEffect)JStatusRegistry.WSPOISON.get())) {
            info.cancel();
        }
    }

    @Inject(cancellable=true, method={"attack"}, at={@At(value="HEAD")})
    public void jcraft$attack(Entity target, CallbackInfo info) {
        JSpec<?, ?> spec;
        Player player = (Player)this;
        if (JUtils.isAffectedByTimeStop((Entity)player)) {
            info.cancel();
        }
        if (JUtils.getStand((LivingEntity)player) != null && player.m_21205_().m_41638_(EquipmentSlot.MAINHAND).isEmpty()) {
            info.cancel();
        }
        if ((spec = JComponentPlatformUtils.getSpecData((LivingEntity)player).getSpec()) != null && spec.moveStun > 0) {
            info.cancel();
        }
    }

    @Inject(cancellable=true, at={@At(value="HEAD")}, method={"actuallyHurt"})
    protected void jcraft$applyDamage(DamageSource source, float amount, CallbackInfo info) {
        Player player = (Player)this;
        Entity entity = player.m_146895_();
        if (entity instanceof StandEntity) {
            StandEntity stand = (StandEntity)entity;
            AbstractMove attack = stand.getCurrentMove();
            if (attack == null || !attack.isCounter() || stand.getMoveStun() >= attack.getDuration() - attack.getWindup()) {
                return;
            }
            ((AbstractCounterAttack)attack).counter(stand, source.m_7639_(), source);
            player.m_21195_((MobEffect)JStatusRegistry.DAZED.get());
            info.cancel();
        }
    }

    @Inject(cancellable=true, method={"jumpFromGround"}, at={@At(value="HEAD")})
    public void jcraft$jumpFromGround(CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        if (!JUtils.canJump(entity)) {
            ci.cancel();
        }
    }

    @Inject(cancellable=true, at={@At(value="HEAD")}, method={"startFallFlying"})
    void jcraft$startFallFlying(CallbackInfo ci) {
        Player player = (Player)this;
        if (JServerConfig.DISABLE_COMBAT_ELYTRA.getValue() && JComponentPlatformUtils.getMiscData((LivingEntity)player).isOnDamageTimer()) {
            ci.cancel();
        }
    }
}

