/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.mixin.client;

import java.util.function.BooleanSupplier;
import net.arna.jcraft.common.entity.stand.CreamEntity;
import net.arna.jcraft.common.util.IJSplatterManagerHolder;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={ClientLevel.class})
public abstract class ClientWorldMixin
implements IJSplatterManagerHolder {
    @Inject(cancellable=true, at={@At(value="HEAD")}, method={"tickNonPassenger"})
    private void timestopTick(Entity entity, CallbackInfo ci) {
        if (JComponentPlatformUtils.getTimeStopData(entity).isPresent()) {
            JComponentPlatformUtils.getTimeStopData(entity).get().tick(ci);
        }
    }

    @Inject(method={"playSound"}, at={@At(value="HEAD")}, cancellable=true)
    private void playSound(double x, double y, double z, SoundEvent soundEvent, SoundSource source, float volume, float pitch, boolean distanceDelay, long seed, CallbackInfo ci) {
        CreamEntity cream;
        Entity entity;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && (entity = player.m_146895_()) instanceof CreamEntity && (cream = (CreamEntity)entity).getVoidTime() > 0) {
            ci.cancel();
        }
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void tickSplatters(BooleanSupplier shouldKeepTicking, CallbackInfo ci) {
        this.jcraft$getSplatterManager().tick();
    }
}

