/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.mixin.client;

import java.util.HashMap;
import java.util.Map;
import net.arna.jcraft.client.renderer.entity.PlayerCloneRenderer;
import net.arna.jcraft.client.rendering.CloneSkinTracker;
import net.arna.jcraft.client.util.JClientUtils;
import net.arna.jcraft.common.entity.PlayerCloneEntity;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={EntityRenderDispatcher.class})
public abstract class EntityRenderDispatcherMixin {
    @Unique
    private final Map<String, PlayerCloneRenderer> cloneRenderers = new HashMap<String, PlayerCloneRenderer>();

    @Shadow
    public abstract <T extends Entity> EntityRenderer<? super T> m_114382_(T var1);

    @Inject(method={"shouldRender"}, at={@At(value="HEAD")}, cancellable=true)
    private <E extends Entity> void jcraft$shouldRender(E entity, Frustum frustum, double x, double y, double z, CallbackInfoReturnable<Boolean> cir) {
        Object e = entity;
        do {
            PlayerCloneEntity clone;
            if (JClientUtils.shouldForceRender(e)) {
                cir.setReturnValue((Object)true);
                return;
            }
            if (e instanceof PlayerCloneEntity && !this.m_114382_(clone = (PlayerCloneEntity)e).m_5523_((Entity)clone, frustum, x, y, z)) {
                cir.setReturnValue((Object)false);
                return;
            }
            if (!JClientUtils.shouldNotRender(e)) continue;
            cir.setReturnValue((Object)false);
            return;
        } while ((e = e.m_20202_()) != null);
    }

    @Inject(method={"getRenderer"}, at={@At(value="HEAD")}, cancellable=true)
    private <T extends Entity> void getCloneRenderer(T entity, CallbackInfoReturnable<EntityRenderer<? super T>> cir) {
        if (!(entity instanceof PlayerCloneEntity)) {
            return;
        }
        PlayerCloneEntity clone = (PlayerCloneEntity)entity;
        cir.setReturnValue((Object)((EntityRenderer)this.cloneRenderers.getOrDefault(CloneSkinTracker.getModelFor(clone), this.cloneRenderers.get("default"))));
    }

    @Inject(method={"onResourceManagerReload"}, at={@At(value="RETURN")}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    private void reloadCloneRenderers(ResourceManager manager, CallbackInfo ci, EntityRendererProvider.Context context) {
        this.cloneRenderers.clear();
        this.cloneRenderers.put("default", new PlayerCloneRenderer(context, false));
        this.cloneRenderers.put("slim", new PlayerCloneRenderer(context, true));
    }
}

