/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.mixin.client.gravity;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.Optional;
import net.arna.jcraft.common.gravity.RotationAnimation;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.gravity.util.CompatMath;
import net.minecraft.client.Camera;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Camera.class}, priority=1001)
public abstract class CameraMixin {
    @Shadow
    private Entity f_90551_;
    @Shadow
    @Final
    private Quaternionf f_90559_;
    @Shadow
    private float f_90563_;
    @Shadow
    private float f_90562_;
    private float storedTickDelta = 0.0f;

    @Shadow
    protected abstract void m_90584_(double var1, double var3, double var5);

    @Inject(method={"setup"}, at={@At(value="HEAD")})
    private void inject_update(BlockGetter area, Entity entity, boolean detached, boolean thirdPersonReverse, float tickDelta, CallbackInfo ci) {
        this.storedTickDelta = tickDelta;
    }

    @WrapOperation(method={"setup"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Camera;setPosition(DDD)V", ordinal=0)})
    private void wrapOperation_update_setPos_0(Camera camera, double x, double y, double z, Operation<Void> original, BlockGetter area, Entity entity, boolean thirdPerson, boolean inverseView, float tickDelta) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(entity);
        Optional<RotationAnimation> animationOptional = GravityChangerAPI.getGravityAnimation(entity);
        if (animationOptional.isEmpty()) {
            original.call(new Object[]{this, x, y, z});
            return;
        }
        RotationAnimation animation = animationOptional.get();
        if (gravityDirection == Direction.DOWN && !animation.isInAnimation()) {
            original.call(new Object[]{this, x, y, z});
            return;
        }
        long timeMs = entity.m_9236_().m_46467_() * 50L + (long)(this.storedTickDelta * 50.0f);
        Quaternionf gravityRotation = animation.getCurrentGravityRotation(gravityDirection, timeMs).conjugate();
        double entityX = Mth.m_14139_((double)tickDelta, (double)entity.f_19790_, (double)entity.m_20185_());
        double entityY = Mth.m_14139_((double)tickDelta, (double)entity.f_19791_, (double)entity.m_20186_());
        double entityZ = Mth.m_14139_((double)tickDelta, (double)entity.f_19792_, (double)entity.m_20189_());
        double currentCameraY = Mth.m_14179_((float)tickDelta, (float)this.f_90563_, (float)this.f_90562_);
        Vector3f eyeOffset = new Vector3f(0.0f, (float)currentCameraY, 0.0f);
        eyeOffset.rotate((Quaternionfc)gravityRotation);
        original.call(new Object[]{this, entityX + (double)eyeOffset.x(), entityY + (double)eyeOffset.y(), entityZ + (double)eyeOffset.z()});
    }

    @Inject(method={"setRotation"}, at={@At(value="INVOKE", target="Lorg/joml/Quaternionf;rotationYXZ(FFF)Lorg/joml/Quaternionf;", shift=At.Shift.AFTER, remap=false)})
    private void inject_setRotation(CallbackInfo ci) {
        if (this.f_90551_ != null) {
            Direction gravityDirection = GravityChangerAPI.getGravityDirection(this.f_90551_);
            Optional<RotationAnimation> animationOptional = GravityChangerAPI.getGravityAnimation(this.f_90551_);
            if (animationOptional.isEmpty()) {
                return;
            }
            RotationAnimation animation = animationOptional.get();
            if (gravityDirection == Direction.DOWN && !animation.isInAnimation()) {
                return;
            }
            long timeMs = this.f_90551_.m_9236_().m_46467_() * 50L + (long)(this.storedTickDelta * 50.0f);
            Quaternionf rotation = animation.getCurrentGravityRotation(gravityDirection, timeMs).conjugate();
            Quaternionf product = CompatMath.hamiltonProduct(rotation, this.f_90559_);
            this.f_90559_.set(product.x(), product.y(), product.z(), product.w());
        }
    }
}

