/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.mixin.client.gravity;

import java.util.Map;
import java.util.UUID;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.gravity.util.RotationUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={ClientPacketListener.class})
public abstract class ClientPlayNetworkHandlerMixin {
    @Shadow
    @Final
    private Minecraft f_104888_;
    @Shadow
    @Final
    private Map<UUID, PlayerInfo> f_104892_;

    @Redirect(method={"handleGameEvent"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getEyeY()D"))
    private double redirect_onGameStateChange_getEyeY_0(Player playerEntity) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)playerEntity);
        if (gravityDirection == Direction.DOWN) {
            return playerEntity.m_20188_();
        }
        return playerEntity.m_146892_().f_82480_;
    }

    @Redirect(method={"handleGameEvent"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getX()D"))
    private double redirect_onGameStateChange_getX_0(Player playerEntity) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)playerEntity);
        if (gravityDirection == Direction.DOWN) {
            return playerEntity.m_20185_();
        }
        return playerEntity.m_146892_().f_82479_;
    }

    @Redirect(method={"handleGameEvent"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getZ()D"))
    private double redirect_onGameStateChange_getZ_0(Player playerEntity) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)playerEntity);
        if (gravityDirection == Direction.DOWN) {
            return playerEntity.m_20189_();
        }
        return playerEntity.m_146892_().f_82481_;
    }

    @Redirect(method={"handleExplosion"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/Vec3;add(DDD)Lnet/minecraft/world/phys/Vec3;"))
    private Vec3 redirect_onExplosion_add_0(Vec3 vec3d, double x, double y, double z) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this.f_104888_.f_91074_);
        if (gravityDirection == Direction.DOWN) {
            return vec3d.m_82520_(x, y, z);
        }
        return vec3d.m_82549_(RotationUtil.vecWorldToPlayer(x, y, z, gravityDirection));
    }
}

