/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.mixin.client.gravity;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import net.arna.jcraft.common.gravity.RotationAnimation;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import org.joml.Quaternionf;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRenderer.class})
public abstract class GameRendererMixin {
    @Shadow
    @Final
    private Camera f_109054_;

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;mulPose(Lorg/joml/Quaternionf;)V", ordinal=1, shift=At.Shift.AFTER)}, slice={@Slice(from=@At(value="FIELD", target="Lcom/mojang/math/Axis;XP:Lcom/mojang/math/Axis;"))})
    private void inject_renderWorld(float tickDelta, long limitTime, PoseStack matrix, CallbackInfo ci) {
        Entity focusedEntity = this.f_109054_.m_90592_();
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(focusedEntity);
        Optional<RotationAnimation> animationOptional = GravityChangerAPI.getGravityAnimation(focusedEntity);
        if (animationOptional.isEmpty()) {
            return;
        }
        RotationAnimation animation = animationOptional.get();
        long timeMs = focusedEntity.m_9236_().m_46467_() * 50L + (long)(tickDelta * 50.0f);
        Quaternionf currentGravityRotation = animation.getCurrentGravityRotation(gravityDirection, timeMs);
        matrix.m_252781_(currentGravityRotation);
    }
}

