/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.mixin.gravity;

import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.gravity.util.RotationUtil;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={CrossbowItem.class})
public abstract class CrossbowItemMixin {
    @Redirect(method={"shootProjectile"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getX()D"))
    private static double redirect_shoot_getX_0(LivingEntity livingEntity) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)livingEntity);
        if (gravityDirection == Direction.DOWN) {
            return livingEntity.m_20185_();
        }
        return livingEntity.m_146892_().m_82546_((Vec3)RotationUtil.vecPlayerToWorld((double)0.0, (double)((double)0.15f), (double)0.0, (Direction)gravityDirection)).f_82479_;
    }

    @Redirect(method={"shootProjectile"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getEyeY()D"))
    private static double redirect_shoot_getEyeY_0(LivingEntity livingEntity) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)livingEntity);
        if (gravityDirection == Direction.DOWN) {
            return livingEntity.m_20188_();
        }
        return livingEntity.m_146892_().m_82546_((Vec3)RotationUtil.vecPlayerToWorld((double)0.0, (double)((double)0.15f), (double)0.0, (Direction)gravityDirection)).f_82480_ + (double)0.15f;
    }

    @Redirect(method={"shootProjectile"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getZ()D"))
    private static double redirect_shoot_getZ_0(LivingEntity livingEntity) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)livingEntity);
        if (gravityDirection == Direction.DOWN) {
            return livingEntity.m_20189_();
        }
        return livingEntity.m_146892_().m_82546_((Vec3)RotationUtil.vecPlayerToWorld((double)0.0, (double)((double)0.15f), (double)0.0, (Direction)gravityDirection)).f_82481_;
    }
}

