/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.mixin.gravity;

import java.util.List;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.gravity.util.RotationUtil;
import net.arna.jcraft.mixin_logic.EntityMixinLogic;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Shadow
    @Final
    protected RandomSource f_19796_;
    @Shadow
    private EntityDimensions f_19815_;
    @Shadow
    private Level f_19853_;

    @Shadow
    public abstract Vec3 m_20182_();

    @Shadow
    public abstract float m_146909_();

    @Shadow
    public abstract double m_20186_();

    @Shadow
    protected abstract void m_6088_();

    @Shadow
    public abstract Vec3 m_146892_();

    @Inject(method={"makeBoundingBox"}, at={@At(value="RETURN")}, cancellable=true)
    private void inject_calculateBoundingBox(CallbackInfoReturnable<AABB> cir) {
        EntityMixinLogic.inject_calculateBoundingBox((Entity)this, cir);
    }

    @Inject(method={"getBoundingBoxForPose"}, at={@At(value="RETURN")}, cancellable=true)
    private void inject_calculateBoundsForPose(Pose pos, CallbackInfoReturnable<AABB> cir) {
        EntityMixinLogic.inject_calculateBoundsForPose((Entity)this, cir);
    }

    @Inject(method={"calculateViewVector"}, at={@At(value="RETURN")}, cancellable=true)
    private void inject_getRotationVector(CallbackInfoReturnable<Vec3> cir) {
        EntityMixinLogic.inject_getRotationVector((Entity)this, cir);
    }

    @Inject(method={"getBlockPosBelowThatAffectsMyMovement"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject_getVelocityAffectingPos(CallbackInfoReturnable<BlockPos> cir) {
        EntityMixinLogic.inject_getVelocityAffectingPos((Entity)this, cir);
    }

    @Inject(method={"getEyePosition()Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject_getEyePos(CallbackInfoReturnable<Vec3> cir) {
        EntityMixinLogic.inject_getEyePos((Entity)this, cir);
    }

    @Inject(method={"getEyePosition(F)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject_getCameraPosVec(float tickDelta, CallbackInfoReturnable<Vec3> cir) {
        EntityMixinLogic.inject_getCameraPosVec((Entity)this, tickDelta, cir);
    }

    @Inject(method={"getLightLevelDependentMagicValue"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject_getBrightnessAtFEyes(CallbackInfoReturnable<Float> cir) {
        EntityMixinLogic.inject_getBrightnessAtFEyes((Entity)this, cir);
    }

    @ModifyVariable(method={"move"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private Vec3 modify_move_Vec3d_0_0(Vec3 vec3d) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return vec3d;
        }
        return RotationUtil.vecPlayerToWorld(vec3d, gravityDirection);
    }

    @ModifyArg(method={"move"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/Vec3;multiply(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;"), index=0)
    private Vec3 modify_move_multiply_0(Vec3 vec3d) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return vec3d;
        }
        return RotationUtil.maskPlayerToWorld(vec3d, gravityDirection);
    }

    @ModifyVariable(method={"move"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/profiling/ProfilerFiller;pop()V"), ordinal=0, argsOnly=true)
    private Vec3 modify_move_Vec3d_0_1(Vec3 vec3d) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return vec3d;
        }
        return RotationUtil.vecWorldToPlayer(vec3d, gravityDirection);
    }

    @ModifyVariable(method={"move"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/profiling/ProfilerFiller;pop()V"), ordinal=1)
    private Vec3 modify_move_Vec3d_1(Vec3 vec3d) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return vec3d;
        }
        return RotationUtil.vecWorldToPlayer(vec3d, gravityDirection);
    }

    @Inject(method={"getOnPosLegacy"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject_getOnPosLegacy(CallbackInfoReturnable<BlockPos> cir) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        BlockPos blockPos = BlockPos.m_274446_((Position)RotationUtil.vecPlayerToWorld(0.0, (double)-0.2f, 0.0, gravityDirection).m_82549_(this.m_20182_()));
        cir.setReturnValue((Object)blockPos);
    }

    @Inject(method={"getOnPos()Lnet/minecraft/core/BlockPos;"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject_getOnPos(CallbackInfoReturnable<BlockPos> cir) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        BlockPos blockPos = BlockPos.m_274446_((Position)RotationUtil.vecPlayerToWorld(0.0, (double)-1.0E-5f, 0.0, gravityDirection).m_82549_(this.m_20182_()));
        cir.setReturnValue((Object)blockPos);
    }

    @ModifyVariable(method={"collide"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/level/Level;getEntityCollisions(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/AABB;)Ljava/util/List;"), ordinal=0, argsOnly=true)
    private Vec3 modify_adjustMovementForCollisions_Vec3d_0(Vec3 vec3d) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return vec3d;
        }
        return RotationUtil.vecWorldToPlayer(vec3d, gravityDirection);
    }

    @Inject(method={"collide"}, at={@At(value="RETURN")}, cancellable=true)
    private void inject_adjustMovementForCollisions(CallbackInfoReturnable<Vec3> cir) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        cir.setReturnValue((Object)RotationUtil.vecPlayerToWorld((Vec3)cir.getReturnValue(), gravityDirection));
    }

    @ModifyArg(method={"collide"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/AABB;expandTowards(DDD)Lnet/minecraft/world/phys/AABB;"), index=1)
    private double redirect_adjustMovementForCollisions_stretch_0(double x) {
        Vec3 rotate = new Vec3(x, 0.0, 0.0);
        rotate = RotationUtil.vecPlayerToWorld(rotate, GravityChangerAPI.getGravityDirection((Entity)this));
        return rotate.f_82479_;
    }

    @ModifyArg(method={"collide"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/AABB;expandTowards(DDD)Lnet/minecraft/world/phys/AABB;"), index=1)
    private double redirect_adjustMovementForCollisions_stretch_1(double y) {
        Vec3 rotate = new Vec3(0.0, y, 0.0);
        rotate = RotationUtil.vecPlayerToWorld(rotate, GravityChangerAPI.getGravityDirection((Entity)this));
        return rotate.f_82480_;
    }

    @ModifyArg(method={"collide"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/AABB;expandTowards(DDD)Lnet/minecraft/world/phys/AABB;"), index=1)
    private double redirect_adjustMovementForCollisions_stretch_2(double z) {
        Vec3 rotate = new Vec3(0.0, 0.0, z);
        rotate = RotationUtil.vecPlayerToWorld(rotate, GravityChangerAPI.getGravityDirection((Entity)this));
        return rotate.f_82481_;
    }

    @ModifyArg(method={"collide"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/AABB;move(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/AABB;", ordinal=0), index=0)
    private Vec3 redirect_adjustMovementForCollisions_offset_0(Vec3 vec) {
        Vec3 rotate = vec;
        rotate = RotationUtil.vecPlayerToWorld(rotate, GravityChangerAPI.getGravityDirection((Entity)this));
        return rotate;
    }

    @ModifyArg(method={"collide"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/AABB;move(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/AABB;", ordinal=1))
    private Vec3 redirect_adjustMovementForCollisions_offset_1(Vec3 vec) {
        Vec3 rotate = vec;
        rotate = RotationUtil.vecPlayerToWorld(rotate, GravityChangerAPI.getGravityDirection((Entity)this));
        return rotate;
    }

    @ModifyVariable(method={"collideBoundingBox"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private static Vec3 modify_adjustMovementForCollisions_Vec3d_0(Vec3 vec3d, Entity entity) {
        if (entity == null) {
            return vec3d;
        }
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(entity);
        if (gravityDirection == Direction.DOWN) {
            return vec3d;
        }
        return RotationUtil.vecPlayerToWorld(vec3d, gravityDirection);
    }

    @Inject(method={"collideBoundingBox"}, at={@At(value="RETURN")}, cancellable=true)
    private static void inject_adjustMovementForCollisions(Entity entity, Vec3 movement, AABB entityBoundingBox, Level world, List<VoxelShape> collisions, CallbackInfoReturnable<Vec3> cir) {
        if (entity == null) {
            return;
        }
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(entity);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        cir.setReturnValue((Object)RotationUtil.vecWorldToPlayer((Vec3)cir.getReturnValue(), gravityDirection));
    }

    @Inject(method={"collideBoundingBox"}, at={@At(value="RETURN")}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    private static void redirect_adjustMovementForCollisions_adjustMovementForCollisions_0(@Nullable Entity entity, Vec3 movement, AABB entityBoundingBox, Level world, List<VoxelShape> collisions, CallbackInfoReturnable<Vec3> cir) {
        EntityMixinLogic.redirect_adjustMovementForCollisions_adjustMovementForCollisions_0(entity, movement, entityBoundingBox, world, collisions, cir);
    }

    @ModifyArg(method={"isInWall"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/AABB;ofSize(Lnet/minecraft/world/phys/Vec3;DDD)Lnet/minecraft/world/phys/AABB;", ordinal=0), index=1)
    private double modify_isInsideWall_of_0(double dx) {
        Vec3 rotate = new Vec3(dx, 0.0, 0.0);
        rotate = RotationUtil.vecPlayerToWorld(rotate, GravityChangerAPI.getGravityDirection((Entity)this));
        return rotate.f_82479_;
    }

    @ModifyArg(method={"isInWall"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/AABB;ofSize(Lnet/minecraft/world/phys/Vec3;DDD)Lnet/minecraft/world/phys/AABB;", ordinal=0), index=2)
    private double modify_isInsideWall_of_1(double dy) {
        Vec3 rotate = new Vec3(0.0, dy, 0.0);
        rotate = RotationUtil.vecPlayerToWorld(rotate, GravityChangerAPI.getGravityDirection((Entity)this));
        return rotate.f_82480_;
    }

    @ModifyArg(method={"isInWall"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/AABB;ofSize(Lnet/minecraft/world/phys/Vec3;DDD)Lnet/minecraft/world/phys/AABB;", ordinal=0), index=3)
    private double modify_isInsideWall_of_2(double dz) {
        Vec3 rotate = new Vec3(0.0, 0.0, dz);
        rotate = RotationUtil.vecPlayerToWorld(rotate, GravityChangerAPI.getGravityDirection((Entity)this));
        return rotate.f_82481_;
    }

    @ModifyArg(method={"getDirection"}, at=@At(value="INVOKE", target="Lnet/minecraft/core/Direction;fromYRot(D)Lnet/minecraft/core/Direction;"))
    private double redirect_getHorizontalFacing_getYaw_0(double rotation) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return rotation;
        }
        return RotationUtil.rotPlayerToWorld((float)((float)rotation), (float)this.m_146909_(), (Direction)gravityDirection).f_82470_;
    }

    @Inject(method={"spawnSprintParticle"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject_spawnSprintingParticles(CallbackInfo ci) {
        EntityMixinLogic.inject_spawnSprintingParticles((Entity)this, this.f_19796_, this.f_19815_, ci);
    }

    @Inject(method={"push(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject_pushAwayFrom(Entity entity, CallbackInfo ci) {
        EntityMixinLogic.inject_pushAwayFrom((Entity)this, entity, ci);
    }

    @Inject(method={"checkBelowWorld"}, at={@At(value="HEAD")})
    private void inject_attemptTickInVoid(CallbackInfo ci) {
        if (JCraft.gravityConfig.voidDamageAboveWorld && this.m_20186_() > (double)(this.f_19853_.m_151558_() + 256)) {
            this.m_6088_();
        }
    }

    @ModifyArg(method={"isFree(DDD)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/AABB;move(DDD)Lnet/minecraft/world/phys/AABB;", ordinal=0), index=0)
    private double redirect_doesNotCollide_offset_0(double x) {
        Vec3 rotate = new Vec3(x, 0.0, 0.0);
        rotate = RotationUtil.vecPlayerToWorld(rotate, GravityChangerAPI.getGravityDirection((Entity)this));
        return rotate.f_82479_;
    }

    @ModifyArg(method={"isFree(DDD)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/AABB;move(DDD)Lnet/minecraft/world/phys/AABB;", ordinal=0), index=0)
    private double redirect_doesNotCollide_offset_1(double y) {
        Vec3 rotate = new Vec3(0.0, y, 0.0);
        rotate = RotationUtil.vecPlayerToWorld(rotate, GravityChangerAPI.getGravityDirection((Entity)this));
        return rotate.f_82480_;
    }

    @ModifyArg(method={"isFree(DDD)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/AABB;move(DDD)Lnet/minecraft/world/phys/AABB;", ordinal=0), index=0)
    private double redirect_doesNotCollide_offset_2(double z) {
        Vec3 rotate = new Vec3(0.0, 0.0, z);
        rotate = RotationUtil.vecPlayerToWorld(rotate, GravityChangerAPI.getGravityDirection((Entity)this));
        return rotate.f_82481_;
    }

    @ModifyVariable(method={"updateFluidOnEyes"}, at=@At(value="STORE"), ordinal=0)
    private double submergedInWaterEyeFix(double d) {
        d = this.m_146892_().m_7098_();
        return d;
    }

    @ModifyVariable(method={"updateFluidOnEyes"}, at=@At(value="STORE"), ordinal=0)
    private BlockPos submergedInWaterPosFix(BlockPos blockpos) {
        blockpos = BlockPos.m_274446_((Position)this.m_146892_());
        return blockpos;
    }
}

