/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.mixin.gravity;

import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.gravity.util.RotationUtil;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={Explosion.class})
public abstract class ExplosionMixin {
    @Redirect(method={"explode"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getEyeY()D"))
    private double redirect_collectBlocksAndDamageEntities_getEyeY_0(Entity entity) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(entity);
        if (gravityDirection == Direction.DOWN) {
            return entity.m_20188_();
        }
        return entity.m_146892_().f_82480_;
    }

    @Redirect(method={"explode"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getX()D"))
    private double redirect_collectBlocksAndDamageEntities_getX_0(Entity entity) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(entity);
        if (gravityDirection == Direction.DOWN) {
            return entity.m_20185_();
        }
        return entity.m_146892_().f_82479_;
    }

    @Redirect(method={"explode"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getZ()D"))
    private double redirect_collectBlocksAndDamageEntities_getZ_0(Entity entity) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(entity);
        if (gravityDirection == Direction.DOWN) {
            return entity.m_20189_();
        }
        return entity.m_146892_().f_82481_;
    }

    @Redirect(method={"explode"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getDeltaMovement()Lnet/minecraft/world/phys/Vec3;"))
    private Vec3 redirect_collectBlocksAndDamageEntities_getVelocity_0(Entity entity) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(entity);
        if (gravityDirection == Direction.DOWN) {
            return entity.m_20184_();
        }
        return RotationUtil.vecPlayerToWorld(entity.m_20184_(), gravityDirection);
    }

    @Redirect(method={"explode"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V"))
    private void redirect_collectBlocksAndDamageEntities_setVelocity_0(Entity entity, Vec3 vec3d) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(entity);
        if (gravityDirection == Direction.DOWN) {
            entity.m_20256_(vec3d);
            return;
        }
        entity.m_20256_(RotationUtil.vecWorldToPlayer(vec3d, gravityDirection));
    }
}

