/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.mixin.gravity;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.gravity.util.RotationUtil;
import net.arna.jcraft.mixin_logic.LivingEntityMixinLogic;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    @Shadow
    public abstract void m_7378_(CompoundTag var1);

    @Shadow
    public abstract EntityDimensions m_6972_(Pose var1);

    @Shadow
    public abstract float m_5675_(float var1);

    @Shadow
    public abstract void m_267651_(boolean var1);

    @Shadow
    protected abstract void m_267689_(float var1);

    public LivingEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Redirect(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getY()D", ordinal=0))
    private double redirect_travel_getY_0(LivingEntity livingEntity) {
        return LivingEntityMixinLogic.redirect_travel_getY_0(livingEntity);
    }

    @Redirect(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getY()D", ordinal=1))
    private double redirect_travel_getY_1(LivingEntity livingEntity) {
        return LivingEntityMixinLogic.redirect_travel_getY_0(livingEntity);
    }

    @Redirect(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getY()D", ordinal=2))
    private double redirect_travel_getY_2(LivingEntity livingEntity) {
        return LivingEntityMixinLogic.redirect_travel_getY_0(livingEntity);
    }

    @Redirect(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getY()D", ordinal=3))
    private double redirect_travel_getY_3(LivingEntity livingEntity) {
        return LivingEntityMixinLogic.redirect_travel_getY_0(livingEntity);
    }

    @ModifyVariable(method={"travel"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/entity/LivingEntity;handleRelativeFrictionAndCalculateMovement(Lnet/minecraft/world/phys/Vec3;F)Lnet/minecraft/world/phys/Vec3;"), argsOnly=true)
    private Vec3 modify_travel_Vec3d_2(Vec3 vec3d) {
        return LivingEntityMixinLogic.modify_travel_Vec3d_2(this, vec3d);
    }

    @ModifyArg(method={"playBlockFallSound"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getBlockState(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;", ordinal=0), index=0)
    private BlockPos modify_playBlockFallSound_getBlockState_0(BlockPos blockPos) {
        return LivingEntityMixinLogic.modify_playBlockFallSound_getBlockState_0(this, blockPos, this.m_20182_());
    }

    @Redirect(method={"hasLineOfSight"}, at=@At(value="NEW", target="(DDD)Lnet/minecraft/world/phys/Vec3;", ordinal=0))
    private Vec3 redirect_canSee_new_0(double x, double y, double z) {
        return LivingEntityMixinLogic.redirect_canSee_new_0(this, x, y, z, this.m_146892_());
    }

    @Redirect(method={"hasLineOfSight"}, at=@At(value="NEW", target="(DDD)Lnet/minecraft/world/phys/Vec3;", ordinal=1))
    private Vec3 redirect_canSee_new_1(double x, double y, double z, Entity entity) {
        return LivingEntityMixinLogic.redirect_canSee_new_0(this, x, y, z, this.m_146892_());
    }

    @Inject(method={"getLocalBoundsForPose"}, at={@At(value="RETURN")}, cancellable=true)
    private void inject_getBoundingBox(Pose pose, CallbackInfoReturnable<AABB> cir) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        AABB box = (AABB)cir.getReturnValue();
        if (gravityDirection.m_122421_() == Direction.AxisDirection.POSITIVE) {
            box = box.m_82386_(0.0, -1.0E-6, 0.0);
        }
        cir.setReturnValue((Object)RotationUtil.boxPlayerToWorld(box, gravityDirection));
    }

    @Inject(method={"calculateEntityAnimation"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject_updateLimbs(boolean flutter, CallbackInfo ci) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        ci.cancel();
        Vec3 playerPosDelta = RotationUtil.vecWorldToPlayer(this.m_20185_() - this.f_19854_, this.m_20186_() - this.f_19791_, this.m_20189_() - this.f_19792_, gravityDirection);
        float mag = (float)Mth.m_184648_((double)playerPosDelta.f_82479_, (double)(flutter ? playerPosDelta.f_82480_ : 0.0), (double)playerPosDelta.f_82481_);
        this.m_267689_(mag);
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getX()D", ordinal=0))
    private double redirect_tick_getX_0(LivingEntity livingEntity) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)livingEntity);
        if (gravityDirection == Direction.DOWN) {
            return livingEntity.m_20185_();
        }
        return RotationUtil.vecWorldToPlayer((double)(livingEntity.m_20185_() - livingEntity.f_19854_), (double)(livingEntity.m_20186_() - livingEntity.f_19855_), (double)(livingEntity.m_20189_() - livingEntity.f_19856_), (Direction)gravityDirection).f_82479_ + livingEntity.f_19854_;
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getZ()D", ordinal=0))
    private double redirect_tick_getZ_0(LivingEntity livingEntity) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)livingEntity);
        if (gravityDirection == Direction.DOWN) {
            return livingEntity.m_20189_();
        }
        return RotationUtil.vecWorldToPlayer((double)(livingEntity.m_20185_() - livingEntity.f_19854_), (double)(livingEntity.m_20186_() - livingEntity.f_19855_), (double)(livingEntity.m_20189_() - livingEntity.f_19856_), (Direction)gravityDirection).f_82481_ + livingEntity.f_19856_;
    }

    @Redirect(method={"hurt"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getX()D", ordinal=0))
    private double redirect_damage_getX_0(Entity attacker) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(this);
        if (gravityDirection == Direction.DOWN) {
            if (GravityChangerAPI.getGravityDirection(attacker) == Direction.DOWN) {
                return attacker.m_20185_();
            }
            return attacker.m_146892_().f_82479_;
        }
        return RotationUtil.vecWorldToPlayer((Vec3)attacker.m_146892_(), (Direction)gravityDirection).f_82479_;
    }

    @Redirect(method={"hurt"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getZ()D", ordinal=0))
    private double redirect_damage_getZ_0(Entity attacker) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(this);
        if (gravityDirection == Direction.DOWN) {
            if (GravityChangerAPI.getGravityDirection(attacker) == Direction.DOWN) {
                return attacker.m_20189_();
            }
            return attacker.m_146892_().f_82481_;
        }
        return RotationUtil.vecWorldToPlayer((Vec3)attacker.m_146892_(), (Direction)gravityDirection).f_82481_;
    }

    @Redirect(method={"hurt"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getX()D", ordinal=0))
    private double redirect_damage_getX_0(LivingEntity target) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)target);
        if (gravityDirection == Direction.DOWN) {
            return target.m_20185_();
        }
        return RotationUtil.vecWorldToPlayer((Vec3)target.m_20182_(), (Direction)gravityDirection).f_82479_;
    }

    @Redirect(method={"hurt"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getZ()D", ordinal=0))
    private double redirect_damage_getZ_0(LivingEntity target) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)target);
        if (gravityDirection == Direction.DOWN) {
            return target.m_20189_();
        }
        return RotationUtil.vecWorldToPlayer((Vec3)target.m_20182_(), (Direction)gravityDirection).f_82481_;
    }

    @Redirect(method={"blockedByShield"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getX()D", ordinal=0))
    private double redirect_knockback_getX_0(LivingEntity target) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)target);
        if (gravityDirection == Direction.DOWN) {
            return target.m_20185_();
        }
        return RotationUtil.vecWorldToPlayer((Vec3)target.m_20182_(), (Direction)gravityDirection).f_82479_;
    }

    @Redirect(method={"blockedByShield"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getZ()D", ordinal=0))
    private double redirect_knockback_getZ_0(LivingEntity target) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)target);
        if (gravityDirection == Direction.DOWN) {
            return target.m_20189_();
        }
        return RotationUtil.vecWorldToPlayer((Vec3)target.m_20182_(), (Direction)gravityDirection).f_82481_;
    }

    @Redirect(method={"blockedByShield"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getX()D", ordinal=1))
    private double redirect_knockback_getX_1(LivingEntity attacker, LivingEntity target) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)target);
        if (gravityDirection == Direction.DOWN) {
            if (GravityChangerAPI.getGravityDirection((Entity)attacker) == Direction.DOWN) {
                return attacker.m_20185_();
            }
            return attacker.m_146892_().f_82479_;
        }
        return RotationUtil.vecWorldToPlayer((Vec3)attacker.m_146892_(), (Direction)gravityDirection).f_82479_;
    }

    @Redirect(method={"blockedByShield"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getZ()D", ordinal=1))
    private double redirect_knockback_getZ_1(LivingEntity attacker, LivingEntity target) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)target);
        if (gravityDirection == Direction.DOWN) {
            if (GravityChangerAPI.getGravityDirection((Entity)attacker) == Direction.DOWN) {
                return attacker.m_20189_();
            }
            return attacker.m_146892_().f_82481_;
        }
        return RotationUtil.vecWorldToPlayer((Vec3)attacker.m_146892_(), (Direction)gravityDirection).f_82481_;
    }

    @WrapOperation(method={"baseTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;blockPosition()Lnet/minecraft/core/BlockPos;")})
    private BlockPos redirect_baseTick_new_0(LivingEntity instance, Operation<BlockPos> original) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(this);
        if (gravityDirection == Direction.DOWN) {
            return BlockPos.m_274561_((double)instance.m_20185_(), (double)instance.m_20186_(), (double)instance.m_20189_());
        }
        return (BlockPos)original.call(new Object[]{instance});
    }

    @Redirect(method={"spawnItemParticles"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/Vec3;add(DDD)Lnet/minecraft/world/phys/Vec3;", ordinal=0))
    private Vec3 redirect_spawnItemParticles_add_0(Vec3 vec3d, double x, double y, double z) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(this);
        if (gravityDirection == Direction.DOWN) {
            return vec3d.m_82520_(x, y, z);
        }
        return this.m_146892_().m_82549_(RotationUtil.vecPlayerToWorld(vec3d, gravityDirection));
    }

    @ModifyVariable(method={"spawnItemParticles"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/entity/LivingEntity;getYRot()F", ordinal=0), ordinal=0)
    private Vec3 modify_spawnItemParticles_Vec3d_0(Vec3 vec3d) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(this);
        if (gravityDirection == Direction.DOWN) {
            return vec3d;
        }
        return RotationUtil.vecPlayerToWorld(vec3d, gravityDirection);
    }

    @ModifyArg(method={"tickEffects"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V", ordinal=0), index=1)
    private double modify_tickStatusEffects_addParticle_0(double x) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(this);
        if (gravityDirection == Direction.DOWN) {
            return x;
        }
        Vec3 vec3d = this.m_20182_().m_82546_(RotationUtil.vecPlayerToWorld(this.m_20182_().m_82492_(x, 0.0, 0.0), gravityDirection));
        return vec3d.f_82479_;
    }

    @ModifyArg(method={"tickEffects"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V", ordinal=0), index=2)
    private double modify_tickStatusEffects_addParticle_1(double y) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(this);
        if (gravityDirection == Direction.DOWN) {
            return y;
        }
        Vec3 vec3d = this.m_20182_().m_82546_(RotationUtil.vecPlayerToWorld(this.m_20182_().m_82492_(0.0, y, 0.0), gravityDirection));
        return vec3d.f_82480_;
    }

    @ModifyArg(method={"tickEffects"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V", ordinal=0), index=3)
    private double modify_tickStatusEffects_addParticle_2(double z) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(this);
        if (gravityDirection == Direction.DOWN) {
            return z;
        }
        Vec3 vec3d = this.m_20182_().m_82546_(RotationUtil.vecPlayerToWorld(this.m_20182_().m_82492_(0.0, 0.0, z), gravityDirection));
        return vec3d.f_82481_;
    }

    @ModifyArg(method={"makePoofParticles"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V", ordinal=0), index=1)
    private double modify_addDeathParticless_addParticle_0(double x) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(this);
        if (gravityDirection == Direction.DOWN) {
            return x;
        }
        Vec3 vec3d = this.m_20182_().m_82546_(RotationUtil.vecPlayerToWorld(this.m_20182_().m_82492_(x, 0.0, 0.0), gravityDirection));
        return vec3d.f_82479_;
    }

    @ModifyArg(method={"makePoofParticles"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V", ordinal=0), index=2)
    private double modify_addDeathParticless_addParticle_1(double y) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(this);
        if (gravityDirection == Direction.DOWN) {
            return y;
        }
        Vec3 vec3d = this.m_20182_().m_82546_(RotationUtil.vecPlayerToWorld(this.m_20182_().m_82492_(0.0, y, 0.0), gravityDirection));
        return vec3d.f_82480_;
    }

    @ModifyArg(method={"makePoofParticles"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V", ordinal=0), index=3)
    private double modify_addDeathParticless_addParticle_2(double z) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(this);
        if (gravityDirection == Direction.DOWN) {
            return z;
        }
        Vec3 vec3d = this.m_20182_().m_82546_(RotationUtil.vecPlayerToWorld(this.m_20182_().m_82492_(0.0, 0.0, z), gravityDirection));
        return vec3d.f_82481_;
    }

    @ModifyVariable(method={"isDamageSourceBlocked"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/entity/LivingEntity;getViewVector(F)Lnet/minecraft/world/phys/Vec3;", ordinal=0), ordinal=1)
    private Vec3 modify_blockedByShield_Vec3d_1(Vec3 vec3d) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(this);
        if (gravityDirection == Direction.DOWN) {
            return vec3d;
        }
        return RotationUtil.vecWorldToPlayer(vec3d, gravityDirection);
    }

    @ModifyArg(method={"isDamageSourceBlocked"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/Vec3;vectorTo(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;", ordinal=0), index=0)
    private Vec3 modify_blockedByShield_relativize_0(Vec3 vec3d) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(this);
        if (gravityDirection == Direction.DOWN) {
            return vec3d;
        }
        return this.m_146892_();
    }

    @ModifyVariable(method={"isDamageSourceBlocked"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/phys/Vec3;normalize()Lnet/minecraft/world/phys/Vec3;", ordinal=0), ordinal=2)
    private Vec3 modify_blockedByShield_Vec3d_2(Vec3 vec3d) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(this);
        if (gravityDirection == Direction.DOWN) {
            return vec3d;
        }
        return RotationUtil.vecWorldToPlayer(vec3d, gravityDirection);
    }
}

