/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.mixin.gravity;

import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.gravity.util.RotationUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin
extends LivingEntity {
    @Shadow
    @Final
    private Abilities f_36077_;

    @Shadow
    public abstract EntityDimensions m_6972_(Pose var1);

    @Shadow
    protected abstract boolean m_36343_();

    @Shadow
    protected abstract boolean m_36386_();

    protected PlayerEntityMixin(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Redirect(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getLookAngle()Lnet/minecraft/world/phys/Vec3;", ordinal=0))
    private Vec3 redirect_travel_getLookAngle_0(Player playerEntity) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)playerEntity);
        if (gravityDirection == Direction.DOWN) {
            return playerEntity.m_20154_();
        }
        return RotationUtil.vecWorldToPlayer(playerEntity.m_20154_(), gravityDirection);
    }

    @ModifyArg(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getBlockState(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;"))
    private BlockPos modify_move_multiply_0(BlockPos pos) {
        Vec3 rotate = new Vec3(0.0, 0.9, 0.0);
        rotate = RotationUtil.vecPlayerToWorld(rotate, GravityChangerAPI.getGravityDirection((Entity)this));
        return BlockPos.m_274561_((double)((double)pos.m_123341_() - rotate.f_82479_), (double)((double)pos.m_123342_() - rotate.f_82480_ + 0.9), (double)((double)pos.m_123343_() - rotate.f_82481_));
    }

    @Redirect(method={"drop(Lnet/minecraft/world/item/ItemStack;ZZ)Lnet/minecraft/world/entity/item/ItemEntity;"}, at=@At(value="NEW", target="(Lnet/minecraft/world/level/Level;DDDLnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/entity/item/ItemEntity;"))
    private ItemEntity redirect_dropItem_new_0(Level world, double x, double y, double z, ItemStack stack) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return new ItemEntity(world, x, y, z, stack);
        }
        Vec3 vec3d = this.m_146892_().m_82546_(RotationUtil.vecPlayerToWorld(0.0, (double)0.3f, 0.0, gravityDirection));
        return new ItemEntity(world, vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, stack);
    }

    @Redirect(method={"drop(Lnet/minecraft/world/item/ItemStack;ZZ)Lnet/minecraft/world/entity/item/ItemEntity;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/ItemEntity;setDeltaMovement(DDD)V"))
    private void redirect_dropItem_setVelocity(ItemEntity itemEntity, double x, double y, double z) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            itemEntity.m_20334_(x, y, z);
            return;
        }
        itemEntity.m_20256_(RotationUtil.vecPlayerToWorld(x, y, z, gravityDirection));
    }

    @Inject(method={"maybeBackOffFromEdge"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject_adjustMovementForSneaking(Vec3 movement, MoverType type, CallbackInfoReturnable<Vec3> cir) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        Vec3 playerMovement = RotationUtil.vecWorldToPlayer(movement, gravityDirection);
        if (!this.f_36077_.f_35935_ && (type == MoverType.SELF || type == MoverType.PLAYER) && this.m_36343_() && this.m_36386_()) {
            double d = playerMovement.f_82479_;
            double e = playerMovement.f_82481_;
            double var7 = 0.05;
            while (d != 0.0 && this.m_9236_().m_45756_((Entity)this, this.m_20191_().m_82383_(RotationUtil.vecPlayerToWorld(d, (double)(-this.m_274421_()), 0.0, gravityDirection)))) {
                if (d < 0.05 && d >= -0.05) {
                    d = 0.0;
                    continue;
                }
                if (d > 0.0) {
                    d -= 0.05;
                    continue;
                }
                d += 0.05;
            }
            while (e != 0.0 && this.m_9236_().m_45756_((Entity)this, this.m_20191_().m_82383_(RotationUtil.vecPlayerToWorld(0.0, (double)(-this.m_274421_()), e, gravityDirection)))) {
                if (e < 0.05 && e >= -0.05) {
                    e = 0.0;
                    continue;
                }
                if (e > 0.0) {
                    e -= 0.05;
                    continue;
                }
                e += 0.05;
            }
            while (d != 0.0 && e != 0.0 && this.m_9236_().m_45756_((Entity)this, this.m_20191_().m_82383_(RotationUtil.vecPlayerToWorld(d, (double)(-this.m_274421_()), e, gravityDirection)))) {
                d = d < 0.05 && d >= -0.05 ? 0.0 : (d > 0.0 ? (d -= 0.05) : (d += 0.05));
                if (e < 0.05 && e >= -0.05) {
                    e = 0.0;
                    continue;
                }
                if (e > 0.0) {
                    e -= 0.05;
                    continue;
                }
                e += 0.05;
            }
            cir.setReturnValue((Object)RotationUtil.vecPlayerToWorld(d, playerMovement.f_82480_, e, gravityDirection));
        } else {
            cir.setReturnValue((Object)movement);
        }
    }

    @Redirect(method={"isAboveGround"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/AABB;move(DDD)Lnet/minecraft/world/phys/AABB;", ordinal=0))
    private AABB redirect_isAboveGround_offset_0(AABB box, double x, double y, double z) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return box.m_82386_(x, y, z);
        }
        return box.m_82383_(RotationUtil.vecPlayerToWorld(x, y, z, gravityDirection));
    }

    @Redirect(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getYRot()F", ordinal=0))
    private float redirect_attack_getYaw_0(Player attacker, Entity target) {
        Direction attackerGravityDirection;
        Direction targetGravityDirection = GravityChangerAPI.getGravityDirection(target);
        if (targetGravityDirection == (attackerGravityDirection = GravityChangerAPI.getGravityDirection((Entity)attacker))) {
            return attacker.m_146908_();
        }
        return RotationUtil.rotWorldToPlayer((Vec2)RotationUtil.rotPlayerToWorld((float)attacker.m_146908_(), (float)attacker.m_146909_(), (Direction)attackerGravityDirection), (Direction)targetGravityDirection).f_82470_;
    }

    @Redirect(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getYRot()F", ordinal=1))
    private float redirect_attack_getYaw_1(Player attacker, Entity target) {
        Direction attackerGravityDirection;
        Direction targetGravityDirection = GravityChangerAPI.getGravityDirection(target);
        if (targetGravityDirection == (attackerGravityDirection = GravityChangerAPI.getGravityDirection((Entity)attacker))) {
            return attacker.m_146908_();
        }
        return RotationUtil.rotWorldToPlayer((Vec2)RotationUtil.rotPlayerToWorld((float)attacker.m_146908_(), (float)attacker.m_146909_(), (Direction)attackerGravityDirection), (Direction)targetGravityDirection).f_82470_;
    }

    @Redirect(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getYRot()F", ordinal=2))
    private float redirect_attack_getYaw_2(Player attacker) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)attacker);
        if (gravityDirection == Direction.DOWN) {
            return attacker.m_146908_();
        }
        return RotationUtil.rotPlayerToWorld((float)attacker.m_146908_(), (float)attacker.m_146909_(), (Direction)gravityDirection).f_82470_;
    }

    @Redirect(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getYRot()F", ordinal=3))
    private float redirect_attack_getYaw_3(Player attacker) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)attacker);
        if (gravityDirection == Direction.DOWN) {
            return attacker.m_146908_();
        }
        return RotationUtil.rotPlayerToWorld((float)attacker.m_146908_(), (float)attacker.m_146909_(), (Direction)gravityDirection).f_82470_;
    }

    @ModifyArg(method={"addParticlesAroundSelf"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V", ordinal=0), index=1)
    private double modify_addDeathParticless_addParticle_0(double x) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return x;
        }
        Vec3 vec3d = this.m_20182_().m_82546_(RotationUtil.vecPlayerToWorld(this.m_20182_().m_82492_(this.m_20208_(1.0), this.m_20187_() + 1.0, this.m_20262_(1.0)), gravityDirection));
        return vec3d.f_82479_;
    }

    @ModifyArg(method={"addParticlesAroundSelf"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V", ordinal=0), index=1)
    private double modify_addDeathParticless_addParticle_1(double y) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return y;
        }
        Vec3 vec3d = this.m_20182_().m_82546_(RotationUtil.vecPlayerToWorld(this.m_20182_().m_82492_(this.m_20208_(1.0), this.m_20187_() + 1.0, this.m_20262_(1.0)), gravityDirection));
        return vec3d.f_82480_;
    }

    @ModifyArg(method={"addParticlesAroundSelf"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V", ordinal=0), index=1)
    private double modify_addDeathParticless_addParticle_2(double z) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return z;
        }
        Vec3 vec3d = this.m_20182_().m_82546_(RotationUtil.vecPlayerToWorld(this.m_20182_().m_82492_(this.m_20208_(1.0), this.m_20187_() + 1.0, this.m_20262_(1.0)), gravityDirection));
        return vec3d.f_82481_;
    }

    @ModifyArg(method={"aiStep"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/AABB;inflate(DDD)Lnet/minecraft/world/phys/AABB;", ordinal=0), index=1)
    private double modify_tickMovement_expand_0(double x) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return x;
        }
        Vec3 vec3d = RotationUtil.maskPlayerToWorld(1.0, 0.0, 1.0, gravityDirection);
        return vec3d.f_82479_;
    }

    @ModifyArg(method={"aiStep"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/AABB;inflate(DDD)Lnet/minecraft/world/phys/AABB;", ordinal=0), index=1)
    private double modify_tickMovement_expand_1(double y) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return y;
        }
        Vec3 vec3d = RotationUtil.maskPlayerToWorld(1.0, 0.0, 1.0, gravityDirection);
        return vec3d.f_82480_;
    }

    @ModifyArg(method={"aiStep"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/AABB;inflate(DDD)Lnet/minecraft/world/phys/AABB;", ordinal=0), index=1)
    private double modify_tickMovement_expand_2(double z) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return z;
        }
        Vec3 vec3d = RotationUtil.maskPlayerToWorld(1.0, 0.0, 1.0, gravityDirection);
        return vec3d.f_82481_;
    }

    @ModifyArg(method={"aiStep"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/AABB;inflate(DDD)Lnet/minecraft/world/phys/AABB;", ordinal=1), index=1)
    private double modify_tickMovement_expand_3(double x) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return x;
        }
        Vec3 vec3d = RotationUtil.maskPlayerToWorld(1.0, 0.0, 1.0, gravityDirection);
        return vec3d.f_82479_;
    }

    @ModifyArg(method={"aiStep"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/AABB;inflate(DDD)Lnet/minecraft/world/phys/AABB;", ordinal=1), index=1)
    private double modify_tickMovement_expand_4(double y) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return y;
        }
        Vec3 vec3d = RotationUtil.maskPlayerToWorld(1.0, 0.0, 1.0, gravityDirection);
        return vec3d.f_82480_;
    }

    @ModifyArg(method={"aiStep"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/AABB;inflate(DDD)Lnet/minecraft/world/phys/AABB;", ordinal=1), index=1)
    private double modify_tickMovement_expand_5(double z) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return z;
        }
        Vec3 vec3d = RotationUtil.maskPlayerToWorld(1.0, 0.0, 1.0, gravityDirection);
        return vec3d.f_82481_;
    }
}

